/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;

public abstract class BaseFlusher
extends BaseThread {
    protected String date = new Date(System.currentTimeMillis()).toString();
    private File logFile = null;
    private FileOutputStream os;
    protected final byte[] datas = new byte[32768];
    public static final int MAX_LOG_FILE_SIZE = 0x6400000;

    public BaseFlusher(String name) {
        super(name);
    }

    protected FileOutputStream createNewFile() {
        try {
            this.date = new Date(System.currentTimeMillis()).toString();
            String dir = this.getFilePath();
            String fileName = this.getFileName();
            if (StringUtil.isNotEmpty(dir) && StringUtil.isNotEmpty(fileName)) {
                File logPath = new File(dir);
                if (!logPath.exists()) {
                    logPath.mkdirs();
                }
                this.logFile = new File(String.valueOf(dir) + fileName);
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
                return new FileOutputStream(this.logFile, true);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    protected void closeCurrentFile() {
        if (this.os != null) {
            try {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    this.os = null;
                }
            }
            finally {
                this.os = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int getFlushFreq() {
        return 0;
    }

    private boolean needCreateNewFile() {
        String value = new Date(System.currentTimeMillis()).toString();
        return !value.equals(this.date) || this.logFile == null || this.logFile.length() > 0x6400000L;
    }

    protected String getFileName() {
        return String.valueOf(this.date) + "_" + System.currentTimeMillis() + ".log";
    }

    protected abstract String getFilePath();

    protected abstract void doFlush() throws Exception;

    protected void writeAndFlush(String[] logs, int startOff, int len) throws IOException {
        if (this.os != null) {
            int bufferOffset = 0;
            byte[] bytes = null;
            int bytesOffset = 0;
            int i = startOff;
            while (i < startOff + len) {
                bytesOffset = 0;
                bytes = (String.valueOf(logs[i]) + StringUtil.LINE_SEPARATOR).getBytes();
                while (bytesOffset < bytes.length) {
                    int appendlen = bytes.length - bytesOffset <= this.datas.length - bufferOffset ? bytes.length - bytesOffset : this.datas.length - bufferOffset;
                    System.arraycopy(bytes, bytesOffset, this.datas, bufferOffset, appendlen);
                    bytesOffset += appendlen;
                    if (this.datas.length != (bufferOffset += appendlen)) continue;
                    this.os.write(this.datas, 0, bufferOffset);
                    bufferOffset = 0;
                }
                ++i;
            }
            if (bufferOffset > 0) {
                this.os.write(this.datas, 0, bufferOffset);
            }
            this.os.flush();
        }
    }
}

