/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util.stat;

import dm.jdbc.util.StringUtil;
import dm.jdbc.util.stat.JSONUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFormator {
    public static final int COL_MAX_LEN = 32;

    public static void main(String[] args) {
        String[] titles;
        String[] fields = titles = new String[]{"ID", "SQL", "DESC"};
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put(fields[0], "123");
        obj.put(fields[1], "select \r\n1    from dual;");
        obj.put(fields[2], "\u8fbe\u68a6\u6570\u636e\u5e93");
        ArrayList<Map<String, Object>> objList = new ArrayList<Map<String, Object>>();
        objList.add(obj);
        TableFormator.addTitles(objList, titles, fields);
        System.out.println(TableFormator.toTable(objList, fields, null, true, false));
    }

    public static int[] calcColLens(List<Map<String, Object>> objList, String[] fields, int maxColLen) {
        int colLen = 0;
        String colVal = null;
        int[] colLens = new int[fields.length];
        for (Map<String, Object> obj : objList) {
            int i = 0;
            while (i < fields.length) {
                colVal = TableFormator.getColValue(obj.get(fields[i]));
                colLen = colVal.length();
                if (colLen > colLens[i]) {
                    colLens[i] = colLen;
                }
                ++i;
            }
        }
        if (maxColLen > 0) {
            int i = 0;
            while (i < fields.length) {
                if (colLens[i] > maxColLen) {
                    colLens[i] = maxColLen;
                }
                ++i;
            }
        }
        return colLens;
    }

    public static void addTitles(List<Map<String, Object>> objList, String[] titles, String[] fields) {
        HashMap<String, String> titleMap = new HashMap<String, String>(fields.length);
        int i = 0;
        while (i < fields.length) {
            titleMap.put(fields[i], titles[i]);
            ++i;
        }
        objList.add(0, titleMap);
    }

    public static String toTable(List<Map<String, Object>> objList, String[] fields, int[] colLens, boolean showAll, boolean append) {
        if (fields == null || objList == null) {
            return "";
        }
        if (colLens == null) {
            colLens = TableFormator.calcColLens(objList, fields, 32);
        }
        StringBuilder output = new StringBuilder();
        if (!append) {
            TableFormator.sepLine(output, colLens);
        }
        Iterator<Map<String, Object>> iterator = objList.iterator();
        while (iterator.hasNext()) {
            Map obj;
            Map objMore = obj = iterator.next();
            while (objMore != null) {
                objMore = TableFormator.formateLine(output, objMore, fields, colLens, showAll);
            }
            TableFormator.sepLine(output, colLens);
        }
        return output.toString();
    }

    private static Map formateLine(StringBuilder output, Map obj, String[] fields, int[] colLens, boolean showAll) {
        boolean hasMore = false;
        HashMap<String, String> objMore = new HashMap<String, String>();
        int colLen = 0;
        String colVal = null;
        int i = 0;
        while (i < fields.length) {
            colVal = TableFormator.getColValue(obj.get(fields[i]));
            colLen = colVal.length();
            if (colLen <= colLens[i]) {
                output.append('|');
                output.append(colVal);
                TableFormator.blanks(output, colLens[i] - colLen);
                if (showAll) {
                    objMore.put(fields[i], "");
                }
            } else {
                output.append('|');
                if (showAll) {
                    output.append(colVal.substring(0, colLens[i]));
                    objMore.put(fields[i], colVal.substring(colLens[i]));
                    hasMore = true;
                } else {
                    output.append(String.valueOf(colVal.substring(0, colLens[i] - 3)) + "...");
                }
            }
            ++i;
        }
        output.append('|');
        output.append(StringUtil.LINE_SEPARATOR);
        if (hasMore) {
            return objMore;
        }
        return null;
    }

    private static void sepLine(StringBuilder output, int[] colLens) {
        output.append('+');
        int[] nArray = colLens;
        int n = colLens.length;
        int n2 = 0;
        while (n2 < n) {
            int colLen = nArray[n2];
            int i = 0;
            while (i < colLen) {
                output.append('-');
                ++i;
            }
            output.append('+');
            ++n2;
        }
        output.append(StringUtil.LINE_SEPARATOR);
    }

    private static void blanks(StringBuilder output, int count) {
        while (count > 0) {
            output.append(' ');
            --count;
        }
    }

    private static String getColValue(Object colObj) {
        String colVal = colObj == null ? "null" : (colObj.getClass().isArray() ? JSONUtils.toJSONString(colObj) : colObj.toString());
        colVal = colVal.replace('\t', ' ');
        colVal = colVal.replace('\n', ' ');
        colVal = colVal.replace('\r', ' ');
        return colVal;
    }
}

