/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.spring.namespace.parser.common;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.AbstractJobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.JobType;
import java.beans.ConstructorProperties;

public abstract class AbstractJobConfigurationDto<T extends JobConfiguration, J extends ElasticJob, B extends AbstractJobConfiguration.AbstractJobConfigurationBuilder> {
    private final String jobName;
    private final JobType jobType;
    private final Class<? extends J> jobClass;
    private final Integer shardingTotalCount;
    private final String cron;
    private String shardingItemParameters;
    private String jobParameter;
    private Boolean monitorExecution;
    private Integer maxTimeDiffSeconds;
    private Boolean failover;
    private Boolean misfire;
    private Integer monitorPort;
    private String jobShardingStrategyClass;
    private String description;
    private Boolean disabled;
    private Boolean overwrite;

    protected B createBuilder() {
        B builder = this.createCustomizedBuilder();
        this.buildBaselProperties(builder);
        return this.buildCustomizedProperties(builder);
    }

    private void buildBaselProperties(B builder) {
        if (null != this.getShardingItemParameters()) {
            builder.shardingItemParameters(this.getShardingItemParameters());
        }
        if (null != this.getJobParameter()) {
            builder.jobParameter(this.getJobParameter());
        }
        if (null != this.getMonitorExecution()) {
            builder.monitorExecution(this.getMonitorExecution().booleanValue());
        }
        if (null != this.getMaxTimeDiffSeconds()) {
            builder.maxTimeDiffSeconds(this.getMaxTimeDiffSeconds().intValue());
        }
        if (null != this.getMonitorPort()) {
            builder.monitorPort(this.getMonitorPort().intValue());
        }
        if (null != this.getJobShardingStrategyClass()) {
            builder.jobShardingStrategyClass(this.getJobShardingStrategyClass());
        }
        if (null != this.getDescription()) {
            builder.description(this.getDescription());
        }
        this.validateAndBuildJobStatus(builder);
    }

    private void validateAndBuildJobStatus(B builder) {
        if (null != this.getFailover()) {
            builder.failover(this.getFailover().booleanValue());
        }
        if (null != this.getMisfire()) {
            builder.misfire(this.getMisfire().booleanValue());
        }
        if (null != this.getDisabled()) {
            builder.disabled(this.getDisabled().booleanValue());
        }
        if (null != this.getOverwrite()) {
            builder.overwrite(this.getOverwrite().booleanValue());
        }
    }

    protected abstract B createCustomizedBuilder();

    protected abstract B buildCustomizedProperties(B var1);

    public abstract T toJobConfiguration();

    public String getJobName() {
        return this.jobName;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public Class<? extends J> getJobClass() {
        return this.jobClass;
    }

    public Integer getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    public String getCron() {
        return this.cron;
    }

    public String getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    public String getJobParameter() {
        return this.jobParameter;
    }

    public Boolean getMonitorExecution() {
        return this.monitorExecution;
    }

    public Integer getMaxTimeDiffSeconds() {
        return this.maxTimeDiffSeconds;
    }

    public Boolean getFailover() {
        return this.failover;
    }

    public Boolean getMisfire() {
        return this.misfire;
    }

    public Integer getMonitorPort() {
        return this.monitorPort;
    }

    public String getJobShardingStrategyClass() {
        return this.jobShardingStrategyClass;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public void setShardingItemParameters(String shardingItemParameters) {
        this.shardingItemParameters = shardingItemParameters;
    }

    public void setJobParameter(String jobParameter) {
        this.jobParameter = jobParameter;
    }

    public void setMonitorExecution(Boolean monitorExecution) {
        this.monitorExecution = monitorExecution;
    }

    public void setMaxTimeDiffSeconds(Integer maxTimeDiffSeconds) {
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
    }

    public void setFailover(Boolean failover) {
        this.failover = failover;
    }

    public void setMisfire(Boolean misfire) {
        this.misfire = misfire;
    }

    public void setMonitorPort(Integer monitorPort) {
        this.monitorPort = monitorPort;
    }

    public void setJobShardingStrategyClass(String jobShardingStrategyClass) {
        this.jobShardingStrategyClass = jobShardingStrategyClass;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    @ConstructorProperties(value={"jobName", "jobType", "jobClass", "shardingTotalCount", "cron"})
    public AbstractJobConfigurationDto(String jobName, JobType jobType, Class<? extends J> jobClass, Integer shardingTotalCount, String cron) {
        this.jobName = jobName;
        this.jobType = jobType;
        this.jobClass = jobClass;
        this.shardingTotalCount = shardingTotalCount;
        this.cron = cron;
    }
}

