/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorDataMap;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorExceptionHandler;
import com.dangdang.ddframe.rdb.sharding.executor.MergeUnit;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEventBus;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.event.DQLExecutionEventBus;
import com.dangdang.ddframe.rdb.sharding.executor.event.EventExecutionType;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.StatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class StatementExecutor {
    private final ExecutorEngine executorEngine;
    private final Collection<StatementExecutorWrapper> statementExecutorWrappers = new ArrayList<StatementExecutorWrapper>();

    public void addStatement(StatementExecutorWrapper statementExecutorWrapper) {
        this.statementExecutorWrappers.add(statementExecutorWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSet> executeQuery() {
        List<ResultSet> result;
        Timer.Context context = MetricsContext.start("ShardingStatement-executeQuery");
        this.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.statementExecutorWrappers.size()) {
                List<ResultSet> list = Collections.singletonList(this.executeQueryInternal(this.statementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap));
                return list;
            }
            result = this.executorEngine.execute(this.statementExecutorWrappers, new ExecuteUnit<StatementExecutorWrapper, ResultSet>(){

                @Override
                public ResultSet execute(StatementExecutorWrapper input) throws Exception {
                    return StatementExecutor.this.executeQueryInternal(input, isExceptionThrown, dataMap);
                }
            });
        }
        finally {
            MetricsContext.stop(context);
        }
        return result;
    }

    private ResultSet executeQueryInternal(StatementExecutorWrapper statementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        ResultSet result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = statementExecutorWrapper.getStatement().executeQuery(statementExecutorWrapper.getSqlExecutionUnit().getSql());
        }
        catch (SQLException ex) {
            this.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
        this.postExecutionEventsAfterExecution(statementExecutorWrapper);
        return result;
    }

    public int executeUpdate() {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql);
            }
        });
    }

    public int executeUpdate(final int autoGeneratedKeys) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    public int executeUpdate(final int[] columnIndexes) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnIndexes);
            }
        });
    }

    public int executeUpdate(final String[] columnNames) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnNames);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(final Updater updater) {
        Timer.Context context = MetricsContext.start("ShardingStatement-executeUpdate");
        this.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.statementExecutorWrappers.size()) {
                int n = this.executeUpdateInternal(updater, this.statementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap);
                return n;
            }
            int n = this.executorEngine.execute(this.statementExecutorWrappers, new ExecuteUnit<StatementExecutorWrapper, Integer>(){

                @Override
                public Integer execute(StatementExecutorWrapper input) throws Exception {
                    return StatementExecutor.this.executeUpdateInternal(updater, input, isExceptionThrown, dataMap);
                }
            }, new MergeUnit<Integer, Integer>(){

                @Override
                public Integer merge(List<Integer> results) {
                    if (null == results) {
                        return 0;
                    }
                    int result = 0;
                    for (int each : results) {
                        result += each;
                    }
                    return result;
                }
            });
            return n;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private int executeUpdateInternal(Updater updater, StatementExecutorWrapper statementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        int result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = updater.executeUpdate(statementExecutorWrapper.getStatement(), statementExecutorWrapper.getSqlExecutionUnit().getSql());
        }
        catch (SQLException ex) {
            this.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return 0;
        }
        this.postExecutionEventsAfterExecution(statementExecutorWrapper);
        return result;
    }

    public boolean execute() {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql);
            }
        });
    }

    public boolean execute(final int autoGeneratedKeys) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, autoGeneratedKeys);
            }
        });
    }

    public boolean execute(final int[] columnIndexes) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnIndexes);
            }
        });
    }

    public boolean execute(final String[] columnNames) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnNames);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(final Executor executor) {
        Timer.Context context = MetricsContext.start("ShardingStatement-execute");
        this.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.statementExecutorWrappers.size()) {
                boolean bl = this.executeInternal(executor, this.statementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap);
                return bl;
            }
            List<Boolean> result = this.executorEngine.execute(this.statementExecutorWrappers, new ExecuteUnit<StatementExecutorWrapper, Boolean>(){

                @Override
                public Boolean execute(StatementExecutorWrapper input) throws Exception {
                    return StatementExecutor.this.executeInternal(executor, input, isExceptionThrown, dataMap);
                }
            });
            boolean bl = null == result ? false : result.get(0);
            return bl;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private boolean executeInternal(Executor executor, StatementExecutorWrapper statementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        boolean result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = executor.execute(statementExecutorWrapper.getStatement(), statementExecutorWrapper.getSqlExecutionUnit().getSql());
        }
        catch (SQLException ex) {
            this.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return false;
        }
        this.postExecutionEventsAfterExecution(statementExecutorWrapper);
        return result;
    }

    private void postExecutionEvents() {
        for (StatementExecutorWrapper each : this.statementExecutorWrappers) {
            if (each.getDMLExecutionEvent().isPresent()) {
                DMLExecutionEventBus.post((DMLExecutionEvent)each.getDMLExecutionEvent().get());
                continue;
            }
            if (!each.getDQLExecutionEvent().isPresent()) continue;
            DQLExecutionEventBus.post((DQLExecutionEvent)each.getDQLExecutionEvent().get());
        }
    }

    private void postExecutionEventsAfterExecution(StatementExecutorWrapper statementExecutorWrapper) {
        this.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_SUCCESS, (Optional<SQLException>)Optional.absent());
    }

    private void postExecutionEventsAfterExecution(StatementExecutorWrapper statementExecutorWrapper, EventExecutionType eventExecutionType, Optional<SQLException> exp) {
        if (statementExecutorWrapper.getDMLExecutionEvent().isPresent()) {
            DMLExecutionEvent event = (DMLExecutionEvent)statementExecutorWrapper.getDMLExecutionEvent().get();
            event.setEventExecutionType(eventExecutionType);
            event.setExp(exp);
            DMLExecutionEventBus.post(event);
        } else if (statementExecutorWrapper.getDQLExecutionEvent().isPresent()) {
            DQLExecutionEvent event = (DQLExecutionEvent)statementExecutorWrapper.getDQLExecutionEvent().get();
            event.setEventExecutionType(eventExecutionType);
            event.setExp(exp);
            DQLExecutionEventBus.post(event);
        }
    }

    @ConstructorProperties(value={"executorEngine"})
    public StatementExecutor(ExecutorEngine executorEngine) {
        this.executorEngine = executorEngine;
    }

    private static interface Executor {
        public boolean execute(Statement var1, String var2) throws SQLException;
    }

    private static interface Updater {
        public int executeUpdate(Statement var1, String var2) throws SQLException;
    }
}

