/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.dangdang.ddframe.rdb.sharding.executor.PreparedStatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.PreparedStatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractPreparedStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetFactory;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.MergeContext;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ShardingPreparedStatement
extends AbstractPreparedStatementAdapter {
    private final String sql;
    private final List<PreparedStatementExecutorWrapper> cachedRoutedPreparedStatements = new LinkedList<PreparedStatementExecutorWrapper>();
    private Integer autoGeneratedKeys;
    private int[] columnIndexes;
    private String[] columnNames;
    private boolean hasExecuted;
    private final List<List<Object>> batchParameters = new ArrayList<List<Object>>();

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql) throws SQLException {
        this(shardingConnection, sql, 1003, 1007, 1);
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(shardingConnection, sql, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(shardingConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.sql = sql;
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int autoGeneratedKeys) throws SQLException {
        this(shardingConnection, sql);
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int[] columnIndexes) throws SQLException {
        this(shardingConnection, sql);
        this.columnIndexes = columnIndexes;
    }

    public ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, String[] columnNames) throws SQLException {
        this(shardingConnection, sql);
        this.columnNames = columnNames;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.hasExecuted = true;
        this.setCurrentResultSet(ResultSetFactory.getResultSet(new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.getRoutedPreparedStatements()).executeQuery(), this.getMergeContext()));
        return this.getCurrentResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.hasExecuted = true;
        return new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.getRoutedPreparedStatements()).executeUpdate();
    }

    @Override
    public boolean execute() throws SQLException {
        this.hasExecuted = true;
        return new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.getRoutedPreparedStatements()).execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchParameters.add(Lists.newArrayList(this.getParameters()));
        this.getParameters().clear();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchParameters.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.hasExecuted = true;
        int[] result = new int[this.batchParameters.size()];
        int i = 0;
        for (List<Object> each : this.batchParameters) {
            List<PreparedStatementExecutorWrapper> routePreparedStatements = this.routeSQL(each);
            this.cachedRoutedPreparedStatements.addAll(routePreparedStatements);
            result[i++] = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), routePreparedStatements).executeUpdate();
        }
        return result;
    }

    private List<PreparedStatementExecutorWrapper> getRoutedPreparedStatements() throws SQLException {
        if (!this.hasExecuted) {
            return Collections.emptyList();
        }
        this.routeIfNeed();
        return this.cachedRoutedPreparedStatements;
    }

    public List<? extends Statement> getRoutedStatements() throws SQLException {
        return Lists.transform(this.getRoutedPreparedStatements(), (Function)new Function<PreparedStatementExecutorWrapper, Statement>(){

            public Statement apply(PreparedStatementExecutorWrapper input) {
                return input.getPreparedStatement();
            }
        });
    }

    private void routeIfNeed() throws SQLException {
        if (!this.cachedRoutedPreparedStatements.isEmpty()) {
            return;
        }
        this.cachedRoutedPreparedStatements.addAll(this.routeSQL(this.getParameters()));
    }

    private List<PreparedStatementExecutorWrapper> routeSQL(List<Object> parameters) throws SQLException {
        ArrayList<PreparedStatementExecutorWrapper> result = new ArrayList<PreparedStatementExecutorWrapper>();
        SQLRouteResult sqlRouteResult = this.getShardingConnection().getShardingContext().getSqlRouteEngine().route(this.sql, parameters);
        MergeContext mergeContext = sqlRouteResult.getMergeContext();
        this.setMergeContext(mergeContext);
        for (SQLExecutionUnit each : sqlRouteResult.getExecutionUnits()) {
            PreparedStatement preparedStatement = this.generatePrepareStatement(this.getShardingConnection().getConnection(each.getDataSource(), sqlRouteResult.getSqlStatementType()), each.getSql());
            this.replayMethodsInvocation(preparedStatement);
            this.setParameters(preparedStatement, parameters);
            result.add(new PreparedStatementExecutorWrapper(preparedStatement, parameters, each));
        }
        return result;
    }

    private PreparedStatement generatePrepareStatement(Connection conn, String shardingSql) throws SQLException {
        if (null != this.autoGeneratedKeys) {
            return conn.prepareStatement(shardingSql, this.autoGeneratedKeys);
        }
        if (null != this.columnIndexes) {
            return conn.prepareStatement(shardingSql, this.columnIndexes);
        }
        if (null != this.columnNames) {
            return conn.prepareStatement(shardingSql, this.columnNames);
        }
        if (0 != this.getResultSetHoldability()) {
            return conn.prepareStatement(shardingSql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
        }
        return conn.prepareStatement(shardingSql, this.getResultSetType(), this.getResultSetConcurrency());
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        int i = 1;
        for (Object each : parameters) {
            preparedStatement.setObject(i++, each);
        }
    }
}

