/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.dangdang.ddframe.rdb.sharding.executor.StatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.StatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetFactory;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.MergeContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection shardingConnection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final Map<HashCode, Statement> cachedRoutedStatements = new HashMap<HashCode, Statement>();
    private MergeContext mergeContext;
    private ResultSet currentResultSet;

    public ShardingStatement(ShardingConnection shardingConnection) {
        this(shardingConnection, 1003, 1007, 1);
    }

    public ShardingStatement(ShardingConnection shardingConnection, int resultSetType, int resultSetConcurrency) {
        this(shardingConnection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection shardingConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.shardingConnection = shardingConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.shardingConnection;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (null != this.currentResultSet && !this.currentResultSet.isClosed()) {
            this.currentResultSet.close();
        }
        this.currentResultSet = ResultSetFactory.getResultSet(this.generateExecutor(sql).executeQuery(), this.mergeContext);
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.generateExecutor(sql).executeUpdate();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.generateExecutor(sql).executeUpdate(autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.generateExecutor(sql).executeUpdate(columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.generateExecutor(sql).executeUpdate(columnNames);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.generateExecutor(sql).execute();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.generateExecutor(sql).execute(autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.generateExecutor(sql).execute(columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.generateExecutor(sql).execute(columnNames);
    }

    private StatementExecutor generateExecutor(String sql) throws SQLException {
        StatementExecutor result = new StatementExecutor(this.shardingConnection.getShardingContext().getExecutorEngine());
        SQLRouteResult sqlRouteResult = this.shardingConnection.getShardingContext().getSqlRouteEngine().route(sql);
        this.mergeContext = sqlRouteResult.getMergeContext();
        for (SQLExecutionUnit each : sqlRouteResult.getExecutionUnits()) {
            result.addStatement(new StatementExecutorWrapper(this.generateStatement(each.getSql(), each.getDataSource(), sqlRouteResult.getSqlStatementType()), each));
        }
        return result;
    }

    private Statement generateStatement(String sql, String dataSourceName, SQLStatementType sqlStatementType) throws SQLException {
        HashCode hashCode = Hashing.md5().newHasher().putString((CharSequence)sql, Charsets.UTF_8).putString((CharSequence)dataSourceName, Charsets.UTF_8).hash();
        if (this.cachedRoutedStatements.containsKey(hashCode)) {
            return this.cachedRoutedStatements.get(hashCode);
        }
        Connection connection = this.shardingConnection.getConnection(dataSourceName, sqlStatementType);
        Statement result = 0 == this.resultSetHoldability ? connection.createStatement(this.resultSetType, this.resultSetConcurrency) : connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.replayMethodsInvocation(result);
        this.cachedRoutedStatements.put(hashCode, result);
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.getRoutedStatements().size());
        for (Statement statement : this.getRoutedStatements()) {
            resultSets.add(statement.getResultSet());
        }
        this.currentResultSet = ResultSetFactory.getResultSet(resultSets, this.mergeContext);
        return this.currentResultSet;
    }

    @Override
    public Collection<? extends Statement> getRoutedStatements() throws SQLException {
        return this.cachedRoutedStatements.values();
    }

    protected ShardingConnection getShardingConnection() {
        return this.shardingConnection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    protected MergeContext getMergeContext() {
        return this.mergeContext;
    }

    protected void setMergeContext(MergeContext mergeContext) {
        this.mergeContext = mergeContext;
    }

    protected ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    protected void setCurrentResultSet(ResultSet currentResultSet) {
        this.currentResultSet = currentResultSet;
    }
}

