/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row;

import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.ResultSetRow;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public abstract class AbstractResultSetRow
implements ResultSetRow {
    private final Object[] rowData;

    public AbstractResultSetRow(ResultSet resultSet) throws SQLException {
        this.rowData = this.loadData(resultSet);
    }

    private Object[] loadData(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Object[] result = new Object[resultSetMetaData.getColumnCount()];
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            result[i] = resultSet.getObject(i + 1);
        }
        return result;
    }

    @Override
    public final void setCell(int columnIndex, Object value) {
        Preconditions.checkArgument((boolean)this.inRange(columnIndex));
        this.rowData[columnIndex - 1] = value;
    }

    @Override
    public final Object getCell(int columnIndex) {
        Preconditions.checkArgument((boolean)this.inRange(columnIndex));
        return this.rowData[columnIndex - 1];
    }

    @Override
    public final boolean inRange(int columnIndex) {
        return columnIndex > 0 && columnIndex < this.rowData.length + 1;
    }
}

