/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql;

import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.dangdang.ddframe.rdb.sharding.constants.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Table;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.ParseContext;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.SQLVisitor;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import java.util.Arrays;
import java.util.Collections;

public abstract class AbstractMySQLVisitor
extends MySqlOutputVisitor
implements SQLVisitor {
    private ParseContext parseContext;
    private int parseContextIndex;

    protected AbstractMySQLVisitor() {
        super((Appendable)new SQLBuilder());
        this.setPrettyFormat(false);
        this.parseContext = new ParseContext(this.parseContextIndex);
    }

    @Override
    public final DatabaseType getDatabaseType() {
        return DatabaseType.MySQL;
    }

    @Override
    public final ParseContext getParseContext() {
        return this.parseContext;
    }

    protected final void stepInQuery() {
        if (0 == this.parseContextIndex) {
            ++this.parseContextIndex;
            return;
        }
        ParseContext parseContext = new ParseContext(this.parseContextIndex++);
        parseContext.setShardingColumns(this.parseContext.getShardingColumns());
        parseContext.setParentParseContext(this.parseContext);
        this.parseContext.getSubParseContext().add(parseContext);
        this.parseContext = parseContext;
    }

    protected final void stepOutQuery() {
        if (null == this.parseContext.getParentParseContext()) {
            return;
        }
        this.parseContext = this.parseContext.getParentParseContext();
    }

    @Override
    public final SQLBuilder getSQLBuilder() {
        return (SQLBuilder)this.appender;
    }

    @Override
    public final void printToken(String token) {
        this.getSQLBuilder().appendToken(SQLUtil.getExactlyValue(token));
    }

    public final boolean visit(SQLVariantRefExpr x) {
        this.print(x.getName());
        return false;
    }

    public final boolean visit(SQLExprTableSource x) {
        if ("dual".equalsIgnoreCase(SQLUtil.getExactlyValue(x.getExpr().toString()))) {
            return super.visit(x);
        }
        return this.visit(x, this.getParseContext().addTable(x));
    }

    private boolean visit(SQLExprTableSource x, Table table) {
        this.printToken(table.getName());
        if (table.getAlias().isPresent()) {
            this.print(' ');
            this.print((String)table.getAlias().get());
        }
        for (SQLHint each : x.getHints()) {
            this.print(' ');
            each.accept((SQLASTVisitor)this);
        }
        return false;
    }

    public final boolean visit(SQLPropertyExpr x) {
        if (!(x.getParent() instanceof SQLBinaryOpExpr) && !(x.getParent() instanceof SQLSelectItem)) {
            return super.visit(x);
        }
        if (!(x.getOwner() instanceof SQLIdentifierExpr)) {
            return super.visit(x);
        }
        String tableOrAliasName = ((SQLIdentifierExpr)x.getOwner()).getLowerName();
        if (this.getParseContext().isBinaryOperateWithAlias(x, tableOrAliasName)) {
            return super.visit(x);
        }
        this.printToken(tableOrAliasName);
        this.print(".");
        this.print(x.getName());
        return false;
    }

    public boolean visit(SQLBinaryOpExpr x) {
        switch (x.getOperator()) {
            case BooleanOr: {
                this.parseContext.setHasOrCondition(true);
                break;
            }
            case Equality: {
                this.parseContext.addCondition(x.getLeft(), Condition.BinaryOperator.EQUAL, Collections.singletonList(x.getRight()), this.getDatabaseType(), this.getParameters());
                this.parseContext.addCondition(x.getRight(), Condition.BinaryOperator.EQUAL, Collections.singletonList(x.getLeft()), this.getDatabaseType(), this.getParameters());
                break;
            }
        }
        return super.visit(x);
    }

    public boolean visit(SQLInListExpr x) {
        if (!x.isNot()) {
            this.parseContext.addCondition(x.getExpr(), Condition.BinaryOperator.IN, x.getTargetList(), this.getDatabaseType(), this.getParameters());
        }
        return super.visit(x);
    }

    public boolean visit(SQLBetweenExpr x) {
        this.parseContext.addCondition(x.getTestExpr(), Condition.BinaryOperator.BETWEEN, Arrays.asList(x.getBeginExpr(), x.getEndExpr()), this.getDatabaseType(), this.getParameters());
        return super.visit(x);
    }
}

