/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.AbstractSortableColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.AggregationColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.Limit;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.OrderByColumn;
import com.dangdang.ddframe.rdb.sharding.parser.visitor.basic.mysql.AbstractMySQLVisitor;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.List;

public class MySQLSelectVisitor
extends AbstractMySQLVisitor {
    protected void printSelectList(List<SQLSelectItem> selectList) {
        super.printSelectList(selectList);
        this.getSQLBuilder().appendToken(this.getParseContext().getAutoGenTokenKey(), false);
    }

    public boolean visit(MySqlSelectQueryBlock x) {
        this.stepInQuery();
        if (x.getFrom() instanceof SQLExprTableSource) {
            SQLExprTableSource tableExpr = (SQLExprTableSource)x.getFrom();
            this.getParseContext().setCurrentTable(tableExpr.getExpr().toString(), (Optional<String>)Optional.fromNullable((Object)tableExpr.getAlias()));
        }
        return super.visit(x);
    }

    public boolean visit(SQLSelectItem x) {
        this.getParseContext().increaseItemIndex();
        if (Strings.isNullOrEmpty((String)x.getAlias())) {
            SQLExpr expr = x.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                this.getParseContext().registerSelectItem(((SQLIdentifierExpr)expr).getName());
            } else if (expr instanceof SQLPropertyExpr) {
                this.getParseContext().registerSelectItem(((SQLPropertyExpr)expr).getName());
            } else if (expr instanceof SQLAllColumnExpr) {
                this.getParseContext().registerSelectItem("*");
            }
        } else {
            this.getParseContext().registerSelectItem(x.getAlias());
        }
        return super.visit(x);
    }

    public boolean visit(SQLAggregateExpr x) {
        AggregationColumn.AggregationType aggregationType;
        if (!(x.getParent() instanceof SQLSelectItem)) {
            return super.visit(x);
        }
        try {
            aggregationType = AggregationColumn.AggregationType.valueOf(x.getMethodName().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return super.visit(x);
        }
        StringBuilder expression = new StringBuilder();
        x.accept((SQLASTVisitor)new MySqlOutputVisitor((Appendable)expression));
        AggregationColumn column = new AggregationColumn(expression.toString(), aggregationType, (Optional<String>)Optional.fromNullable((Object)((SQLSelectItem)x.getParent()).getAlias()), (Optional<String>)(null == x.getOption() ? Optional.absent() : Optional.of((Object)x.getOption().toString())), this.getParseContext().getItemIndex());
        this.getParseContext().getParsedResult().getMergeContext().getAggregationColumns().add(column);
        if (AggregationColumn.AggregationType.AVG.equals((Object)aggregationType)) {
            this.getParseContext().addDerivedColumnsForAvgColumn(column);
        }
        return super.visit(x);
    }

    public boolean visit(SQLOrderBy x) {
        for (SQLSelectOrderByItem each : x.getItems()) {
            OrderByColumn.OrderByType orderByType;
            SQLExpr expr = each.getExpr();
            OrderByColumn.OrderByType orderByType2 = orderByType = null == each.getType() ? OrderByColumn.OrderByType.ASC : OrderByColumn.OrderByType.valueOf(each.getType());
            if (expr instanceof SQLIntegerExpr) {
                this.getParseContext().addOrderByColumn(((SQLIntegerExpr)expr).getNumber().intValue(), orderByType);
                continue;
            }
            if (expr instanceof SQLIdentifierExpr) {
                this.getParseContext().addOrderByColumn((Optional<String>)Optional.absent(), ((SQLIdentifierExpr)expr).getName(), orderByType);
                continue;
            }
            if (!(expr instanceof SQLPropertyExpr)) continue;
            SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)expr;
            this.getParseContext().addOrderByColumn((Optional<String>)Optional.of((Object)sqlPropertyExpr.getOwner().toString()), sqlPropertyExpr.getName(), orderByType);
        }
        return super.visit(x);
    }

    public boolean visit(MySqlSelectGroupByExpr x) {
        OrderByColumn.OrderByType orderByType;
        OrderByColumn.OrderByType orderByType2 = orderByType = null == x.getType() ? OrderByColumn.OrderByType.ASC : OrderByColumn.OrderByType.valueOf(x.getType());
        if (x.getExpr() instanceof SQLPropertyExpr) {
            SQLPropertyExpr expr = (SQLPropertyExpr)x.getExpr();
            this.getParseContext().addGroupByColumns((Optional<String>)Optional.of((Object)expr.getOwner().toString()), expr.getName(), orderByType);
        } else if (x.getExpr() instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr expr = (SQLIdentifierExpr)x.getExpr();
            this.getParseContext().addGroupByColumns((Optional<String>)Optional.absent(), expr.getName(), orderByType);
        }
        return super.visit(x);
    }

    public boolean visit(MySqlSelectQueryBlock.Limit x) {
        int rowCount;
        this.print("LIMIT ");
        int offset = 0;
        if (null != x.getOffset()) {
            if (x.getOffset() instanceof SQLNumericLiteralExpr) {
                offset = ((SQLNumericLiteralExpr)x.getOffset()).getNumber().intValue();
                this.print("0, ");
            } else {
                offset = ((Number)this.getParameters().get(((SQLVariantRefExpr)x.getOffset()).getIndex())).intValue();
                this.getParameters().set(((SQLVariantRefExpr)x.getOffset()).getIndex(), 0);
                this.print("?, ");
            }
        }
        if (x.getRowCount() instanceof SQLNumericLiteralExpr) {
            rowCount = ((SQLNumericLiteralExpr)x.getRowCount()).getNumber().intValue();
            this.print(rowCount + offset);
        } else {
            rowCount = ((Number)this.getParameters().get(((SQLVariantRefExpr)x.getRowCount()).getIndex())).intValue();
            this.getParameters().set(((SQLVariantRefExpr)x.getRowCount()).getIndex(), rowCount + offset);
            this.print("?");
        }
        this.getParseContext().getParsedResult().getMergeContext().setLimit(new Limit(offset, rowCount));
        return false;
    }

    public void endVisit(MySqlSelectQueryBlock x) {
        StringBuilder derivedSelectItems = new StringBuilder();
        for (AggregationColumn aggregationColumn : this.getParseContext().getParsedResult().getMergeContext().getAggregationColumns()) {
            for (AggregationColumn derivedColumn : aggregationColumn.getDerivedColumns()) {
                derivedSelectItems.append(", ").append(derivedColumn.getExpression()).append(" AS ").append((String)derivedColumn.getAlias().get());
            }
        }
        this.appendSortableColumn(derivedSelectItems, this.getParseContext().getParsedResult().getMergeContext().getGroupByColumns());
        this.appendSortableColumn(derivedSelectItems, this.getParseContext().getParsedResult().getMergeContext().getOrderByColumns());
        if (0 != derivedSelectItems.length()) {
            this.getSQLBuilder().buildSQL(this.getParseContext().getAutoGenTokenKey(), derivedSelectItems.toString());
        }
        super.endVisit(x);
        this.stepOutQuery();
    }

    private void appendSortableColumn(StringBuilder derivedSelectItems, List<? extends AbstractSortableColumn> sortableColumns) {
        for (AbstractSortableColumn abstractSortableColumn : sortableColumns) {
            if (!abstractSortableColumn.getAlias().isPresent()) continue;
            derivedSelectItems.append(", ");
            if (abstractSortableColumn.getOwner().isPresent()) {
                derivedSelectItems.append((String)abstractSortableColumn.getOwner().get()).append(".");
            }
            derivedSelectItems.append((String)abstractSortableColumn.getName().get()).append(" AS ").append((String)abstractSortableColumn.getAlias().get());
        }
    }
}

