/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constants.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.exception.SQLParserException;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.dangdang.ddframe.rdb.sharding.parser.SQLParserFactory;
import com.dangdang.ddframe.rdb.sharding.parser.result.SQLParsedResult;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Table;
import com.dangdang.ddframe.rdb.sharding.router.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import com.dangdang.ddframe.rdb.sharding.router.binding.BindingTablesRouter;
import com.dangdang.ddframe.rdb.sharding.router.mixed.MixedTablesRouter;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleTableRouter;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLRouteEngine {
    private static final Logger log = LoggerFactory.getLogger(SQLRouteEngine.class);
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;

    public SQLRouteResult route(String logicSql) throws SQLParserException {
        return this.route(logicSql, Collections.emptyList());
    }

    public SQLRouteResult route(String logicSql, List<Object> parameters) throws SQLParserException {
        return this.routeSQL(this.parseSQL(logicSql, parameters));
    }

    private SQLParsedResult parseSQL(String logicSql, List<Object> parameters) {
        Timer.Context context = MetricsContext.start("Parse SQL");
        SQLParsedResult result = SQLParserFactory.create(this.databaseType, logicSql, parameters, this.shardingRule.getAllShardingColumns()).parse();
        MetricsContext.stop(context);
        return result;
    }

    private SQLRouteResult routeSQL(SQLParsedResult parsedResult) {
        Timer.Context context = MetricsContext.start("Route SQL");
        SQLRouteResult result = new SQLRouteResult(parsedResult.getRouteContext().getSqlStatementType(), parsedResult.getMergeContext());
        for (ConditionContext each : parsedResult.getConditionContexts()) {
            result.getExecutionUnits().addAll(this.routeSQL(each, Sets.newLinkedHashSet((Iterable)Collections2.transform(parsedResult.getRouteContext().getTables(), (Function)new Function<Table, String>(){

                public String apply(Table input) {
                    return input.getName();
                }
            })), parsedResult.getRouteContext().getSqlBuilder(), parsedResult.getRouteContext().getSqlStatementType()));
        }
        MetricsContext.stop(context);
        log.debug("final route result:{}", result.getExecutionUnits());
        log.debug("merge context:{}", (Object)result.getMergeContext());
        return result;
    }

    private Collection<SQLExecutionUnit> routeSQL(ConditionContext conditionContext, Set<String> logicTables, SQLBuilder sqlBuilder, SQLStatementType type) {
        RoutingResult result = 1 == logicTables.size() ? new SingleTableRouter(this.shardingRule, logicTables.iterator().next(), conditionContext, type).route() : (this.shardingRule.isAllBindingTables(logicTables) ? new BindingTablesRouter(this.shardingRule, logicTables, conditionContext, type).route() : new MixedTablesRouter(this.shardingRule, logicTables, conditionContext, type).route());
        if (null == result) {
            throw new ShardingJdbcException("Sharding-JDBC: cannot route any result, please check your sharding rule.", new Object[0]);
        }
        return result.getSQLExecutionUnits(sqlBuilder);
    }

    @ConstructorProperties(value={"shardingRule", "databaseType"})
    public SQLRouteEngine(ShardingRule shardingRule, DatabaseType databaseType) {
        this.shardingRule = shardingRule;
        this.databaseType = databaseType;
    }
}

