/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.mixed;

import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.mixed.CartesianTableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class CartesianDataSource {
    private final String dataSource;
    private final List<CartesianTableReference> routingTableReferences;

    CartesianDataSource(String dataSource, CartesianTableReference routingTableReference) {
        this.dataSource = dataSource;
        this.routingTableReferences = new ArrayList<CartesianTableReference>(Collections.singletonList(routingTableReference));
    }

    Collection<SQLExecutionUnit> getSQLExecutionUnits(SQLBuilder sqlBuilder) {
        ArrayList<SQLExecutionUnit> result = new ArrayList<SQLExecutionUnit>();
        for (CartesianTableReference each : this.routingTableReferences) {
            each.buildSQL(sqlBuilder);
            result.add(new SQLExecutionUnit(this.dataSource, sqlBuilder.toSQL()));
        }
        return result;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public List<CartesianTableReference> getRoutingTableReferences() {
        return this.routingTableReferences;
    }

    public String toString() {
        return "CartesianDataSource(dataSource=" + this.getDataSource() + ", routingTableReferences=" + this.getRoutingTableReferences() + ")";
    }
}

