/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.mixed;

import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.router.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.mixed.CartesianDataSource;
import com.dangdang.ddframe.rdb.sharding.router.mixed.CartesianTableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class CartesianResult
implements RoutingResult {
    private final List<CartesianDataSource> routingDataSources = new ArrayList<CartesianDataSource>();

    CartesianResult() {
    }

    void merge(String dataSource, Collection<CartesianTableReference> routingTableReferences) {
        for (CartesianTableReference each : routingTableReferences) {
            this.merge(dataSource, each);
        }
    }

    private void merge(String dataSource, CartesianTableReference routingTableReference) {
        for (CartesianDataSource each : this.routingDataSources) {
            if (!each.getDataSource().equals(dataSource)) continue;
            each.getRoutingTableReferences().add(routingTableReference);
            return;
        }
        this.routingDataSources.add(new CartesianDataSource(dataSource, routingTableReference));
    }

    @Override
    public Collection<SQLExecutionUnit> getSQLExecutionUnits(SQLBuilder sqlBuilder) {
        ArrayList<SQLExecutionUnit> result = new ArrayList<SQLExecutionUnit>();
        for (CartesianDataSource each : this.routingDataSources) {
            result.addAll(each.getSQLExecutionUnits(sqlBuilder));
        }
        return result;
    }

    public String toString() {
        return "CartesianResult(routingDataSources=" + this.getRoutingDataSources() + ")";
    }

    public List<CartesianDataSource> getRoutingDataSources() {
        return this.routingDataSources;
    }
}

