/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.single;

import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingTableFactor;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SingleRoutingDataSource {
    private final String dataSource;
    private final List<SingleRoutingTableFactor> routingTableFactors = new ArrayList<SingleRoutingTableFactor>();

    SingleRoutingDataSource(String dataSource, SingleRoutingTableFactor routingTableFactor) {
        this(dataSource);
        this.routingTableFactors.add(routingTableFactor);
    }

    Collection<SQLExecutionUnit> getSQLExecutionUnits(SQLBuilder sqlBuilder) {
        ArrayList<SQLExecutionUnit> result = new ArrayList<SQLExecutionUnit>();
        for (SingleRoutingTableFactor each : this.routingTableFactors) {
            each.buildSQL(sqlBuilder);
            result.add(new SQLExecutionUnit(this.dataSource, sqlBuilder.toSQL()));
        }
        return result;
    }

    Set<String> getLogicTables() {
        HashSet<String> result = new HashSet<String>(this.routingTableFactors.size());
        result.addAll(Lists.transform(this.routingTableFactors, (Function)new Function<SingleRoutingTableFactor, String>(){

            public String apply(SingleRoutingTableFactor input) {
                return input.getLogicTable();
            }
        }));
        return result;
    }

    List<Set<String>> getActualTableGroups(Set<String> logicTables) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        for (String logicTable : logicTables) {
            Set<String> actualTables = this.getActualTables(logicTable);
            if (actualTables.isEmpty()) continue;
            result.add(actualTables);
        }
        return result;
    }

    private Set<String> getActualTables(String logicTable) {
        HashSet<String> result = new HashSet<String>();
        for (SingleRoutingTableFactor each : this.routingTableFactors) {
            if (!each.getLogicTable().equals(logicTable)) continue;
            result.add(each.getActualTable());
        }
        return result;
    }

    Optional<SingleRoutingTableFactor> findRoutingTableFactor(String actualTable) {
        for (SingleRoutingTableFactor each : this.routingTableFactors) {
            if (!each.getActualTable().equals(actualTable)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    @ConstructorProperties(value={"dataSource"})
    public SingleRoutingDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public List<SingleRoutingTableFactor> getRoutingTableFactors() {
        return this.routingTableFactors;
    }

    public String toString() {
        return "SingleRoutingDataSource(dataSource=" + this.getDataSource() + ", routingTableFactors=" + this.getRoutingTableFactors() + ")";
    }
}

