/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.hint.ShardingKey;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class HintManager
implements AutoCloseable {
    private final Map<ShardingKey, ShardingValue<?>> databaseShardingValues = new HashMap();
    private final Map<ShardingKey, ShardingValue<?>> tableShardingValues = new HashMap();
    private boolean shardingHint;
    private boolean masterRouteOnly;

    public static HintManager getInstance() {
        HintManager result = new HintManager();
        HintManagerHolder.setHintManager(result);
        return result;
    }

    public void addDatabaseShardingValue(String logicTable, String shardingColumn, Comparable<?> value) {
        this.addDatabaseShardingValue(logicTable, shardingColumn, Condition.BinaryOperator.EQUAL, value);
    }

    public void addDatabaseShardingValue(String logicTable, String shardingColumn, Condition.BinaryOperator binaryOperator, Comparable<?> ... values) {
        this.shardingHint = true;
        this.databaseShardingValues.put(new ShardingKey(logicTable, shardingColumn), this.getShardingValue(logicTable, shardingColumn, binaryOperator, values));
    }

    public void addTableShardingValue(String logicTable, String shardingColumn, Comparable<?> value) {
        this.addTableShardingValue(logicTable, shardingColumn, Condition.BinaryOperator.EQUAL, value);
    }

    public void addTableShardingValue(String logicTable, String shardingColumn, Condition.BinaryOperator binaryOperator, Comparable<?> ... values) {
        this.shardingHint = true;
        this.tableShardingValues.put(new ShardingKey(logicTable, shardingColumn), this.getShardingValue(logicTable, shardingColumn, binaryOperator, values));
    }

    private ShardingValue getShardingValue(String logicTable, String shardingColumn, Condition.BinaryOperator binaryOperator, Comparable<?>[] values) {
        Preconditions.checkArgument((null != values && values.length > 0 ? 1 : 0) != 0);
        switch (binaryOperator) {
            case EQUAL: {
                return new ShardingValue(logicTable, shardingColumn, values[0]);
            }
            case IN: {
                return new ShardingValue(logicTable, shardingColumn, Arrays.asList(values));
            }
            case BETWEEN: {
                return new ShardingValue(logicTable, shardingColumn, Range.range(values[0], (BoundType)BoundType.CLOSED, values[1], (BoundType)BoundType.CLOSED));
            }
        }
        throw new UnsupportedOperationException(binaryOperator.getExpression());
    }

    public ShardingValue<?> getDatabaseShardingValue(ShardingKey shardingKey) {
        return this.databaseShardingValues.get(shardingKey);
    }

    public ShardingValue<?> getTableShardingValue(ShardingKey shardingKey) {
        return this.tableShardingValues.get(shardingKey);
    }

    public void setMasterRouteOnly() {
        this.masterRouteOnly = true;
    }

    @Override
    public void close() {
        HintManagerHolder.clear();
    }

    private HintManager() {
    }

    public boolean isShardingHint() {
        return this.shardingHint;
    }

    public boolean isMasterRouteOnly() {
        return this.masterRouteOnly;
    }
}

