/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api.rule;

import com.dangdang.ddframe.rdb.sharding.api.rule.BindingTableRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataSourceRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.NoneDatabaseShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.NoneTableShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.TableShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.id.generator.IdGenerator;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public final class ShardingRule {
    private final DataSourceRule dataSourceRule;
    private final Collection<TableRule> tableRules;
    private final Collection<BindingTableRule> bindingTableRules;
    private final DatabaseShardingStrategy databaseShardingStrategy;
    private final TableShardingStrategy tableShardingStrategy;

    @Deprecated
    public ShardingRule(DataSourceRule dataSourceRule, Collection<TableRule> tableRules, Collection<BindingTableRule> bindingTableRules, DatabaseShardingStrategy databaseShardingStrategy, TableShardingStrategy tableShardingStrategy) {
        Preconditions.checkNotNull((Object)dataSourceRule);
        Preconditions.checkNotNull(tableRules);
        this.dataSourceRule = dataSourceRule;
        this.tableRules = tableRules;
        this.bindingTableRules = null == bindingTableRules ? Collections.emptyList() : bindingTableRules;
        this.databaseShardingStrategy = null == databaseShardingStrategy ? new DatabaseShardingStrategy(Collections.emptyList(), new NoneDatabaseShardingAlgorithm()) : databaseShardingStrategy;
        this.tableShardingStrategy = null == tableShardingStrategy ? new TableShardingStrategy(Collections.emptyList(), new NoneTableShardingAlgorithm()) : tableShardingStrategy;
    }

    public static ShardingRuleBuilder builder() {
        return new ShardingRuleBuilder();
    }

    public Optional<TableRule> tryFindTableRule(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(logicTableName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public TableRule findTableRule(String logicTableName) {
        Optional<TableRule> tableRuleOptional = this.tryFindTableRule(logicTableName);
        if (tableRuleOptional.isPresent()) {
            return (TableRule)tableRuleOptional.get();
        }
        throw new ShardingJdbcException(String.format("%s does not exist in ShardingRule", logicTableName), new Object[0]);
    }

    public DatabaseShardingStrategy getDatabaseShardingStrategy(TableRule tableRule) {
        DatabaseShardingStrategy result = tableRule.getDatabaseShardingStrategy();
        if (null == result) {
            result = this.databaseShardingStrategy;
        }
        Preconditions.checkNotNull((Object)result, (Object)"no database sharding strategy");
        return result;
    }

    public TableShardingStrategy getTableShardingStrategy(TableRule tableRule) {
        TableShardingStrategy result = tableRule.getTableShardingStrategy();
        if (null == result) {
            result = this.tableShardingStrategy;
        }
        Preconditions.checkNotNull((Object)result, (Object)"no table sharding strategy");
        return result;
    }

    public boolean isAllBindingTables(Collection<String> logicTables) {
        Collection<String> bindingTables = this.filterAllBindingTables(logicTables);
        return !bindingTables.isEmpty() && bindingTables.containsAll(logicTables);
    }

    public Collection<String> filterAllBindingTables(Collection<String> logicTables) {
        if (logicTables.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTables);
        if (!bindingTableRule.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(((BindingTableRule)bindingTableRule.get()).getAllLogicTables());
        result.retainAll(logicTables);
        return result;
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTables) {
        for (String each : logicTables) {
            Optional<BindingTableRule> result = this.findBindingTableRule(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTable) {
        for (BindingTableRule each : this.bindingTableRules) {
            if (!each.hasLogicTable(logicTable)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public Collection<String> getAllShardingColumns(String tableName) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(this.databaseShardingStrategy.getShardingColumns());
        result.addAll(this.tableShardingStrategy.getShardingColumns());
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(tableName)) continue;
            if (null != each.getDatabaseShardingStrategy()) {
                result.addAll(each.getDatabaseShardingStrategy().getShardingColumns());
            }
            if (null == each.getTableShardingStrategy()) continue;
            result.addAll(each.getTableShardingStrategy().getShardingColumns());
        }
        return result;
    }

    public Collection<String> getAutoIncrementColumns(String tableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(tableName)) continue;
            return Sets.newLinkedHashSet(each.getAutoIncrementColumnMap().keySet());
        }
        return Collections.emptySet();
    }

    public DataSourceRule getDataSourceRule() {
        return this.dataSourceRule;
    }

    public Collection<TableRule> getTableRules() {
        return this.tableRules;
    }

    public Collection<BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    public DatabaseShardingStrategy getDatabaseShardingStrategy() {
        return this.databaseShardingStrategy;
    }

    public TableShardingStrategy getTableShardingStrategy() {
        return this.tableShardingStrategy;
    }

    public static class ShardingRuleBuilder {
        private DataSourceRule dataSourceRule;
        private Collection<TableRule> tableRules;
        private Collection<BindingTableRule> bindingTableRules;
        private DatabaseShardingStrategy databaseShardingStrategy;
        private TableShardingStrategy tableShardingStrategy;
        private Class<? extends IdGenerator> idGeneratorClass;

        public ShardingRuleBuilder dataSourceRule(DataSourceRule dataSourceRule) {
            this.dataSourceRule = dataSourceRule;
            return this;
        }

        public ShardingRuleBuilder tableRules(Collection<TableRule> tableRules) {
            this.tableRules = tableRules;
            return this;
        }

        public ShardingRuleBuilder bindingTableRules(Collection<BindingTableRule> bindingTableRules) {
            this.bindingTableRules = bindingTableRules;
            return this;
        }

        public ShardingRuleBuilder databaseShardingStrategy(DatabaseShardingStrategy databaseShardingStrategy) {
            this.databaseShardingStrategy = databaseShardingStrategy;
            return this;
        }

        public ShardingRuleBuilder tableShardingStrategy(TableShardingStrategy tableShardingStrategy) {
            this.tableShardingStrategy = tableShardingStrategy;
            return this;
        }

        public ShardingRuleBuilder idGenerator(Class<? extends IdGenerator> idGeneratorClass) {
            this.idGeneratorClass = idGeneratorClass;
            return this;
        }

        public ShardingRule build() {
            ShardingRule result = new ShardingRule(this.dataSourceRule, this.tableRules, this.bindingTableRules, this.databaseShardingStrategy, this.tableShardingStrategy);
            if (null == this.idGeneratorClass) {
                return result;
            }
            for (TableRule each : this.tableRules) {
                each.fillIdGenerator(this.idGeneratorClass);
            }
            return result;
        }
    }
}

