/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api.rule;

import com.dangdang.ddframe.rdb.sharding.api.rule.DataNode;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataSourceRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.DynamicDataNode;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.TableShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.id.generator.IdGenerator;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class TableRule {
    private final String logicTable;
    private final boolean dynamic;
    private final List<DataNode> actualTables;
    private final DatabaseShardingStrategy databaseShardingStrategy;
    private final TableShardingStrategy tableShardingStrategy;
    private final Map<String, IdGenerator> autoIncrementColumnMap = new LinkedHashMap<String, IdGenerator>();

    @Deprecated
    public TableRule(String logicTable, boolean dynamic, List<String> actualTables, DataSourceRule dataSourceRule, Collection<String> dataSourceNames, DatabaseShardingStrategy databaseShardingStrategy, TableShardingStrategy tableShardingStrategy) {
        Preconditions.checkNotNull((Object)logicTable);
        this.logicTable = logicTable;
        this.dynamic = dynamic;
        this.databaseShardingStrategy = databaseShardingStrategy;
        this.tableShardingStrategy = tableShardingStrategy;
        if (dynamic) {
            Preconditions.checkNotNull((Object)dataSourceRule);
            this.actualTables = this.generateDataNodes(dataSourceRule);
        } else if (null == actualTables || actualTables.isEmpty()) {
            Preconditions.checkNotNull((Object)dataSourceRule);
            this.actualTables = this.generateDataNodes(Collections.singletonList(logicTable), dataSourceRule, dataSourceNames);
        } else {
            this.actualTables = this.generateDataNodes(actualTables, dataSourceRule, dataSourceNames);
        }
    }

    public static TableRuleBuilder builder(String logicTable) {
        return new TableRuleBuilder(logicTable);
    }

    private List<DataNode> generateDataNodes(DataSourceRule dataSourceRule) {
        Collection<String> dataSourceNames = dataSourceRule.getDataSourceNames();
        ArrayList<DataNode> result = new ArrayList<DataNode>(dataSourceNames.size());
        for (String each : dataSourceNames) {
            result.add(new DynamicDataNode(each));
        }
        return result;
    }

    private List<DataNode> generateDataNodes(List<String> actualTables, DataSourceRule dataSourceRule, Collection<String> actualDataSourceNames) {
        Collection<String> dataSourceNames = this.getDataSourceNames(dataSourceRule, actualDataSourceNames);
        ArrayList<DataNode> result = new ArrayList<DataNode>(actualTables.size() * (dataSourceNames.isEmpty() ? 1 : dataSourceNames.size()));
        for (String actualTable : actualTables) {
            if (DataNode.isValidDataNode(actualTable)) {
                result.add(new DataNode(actualTable));
                continue;
            }
            for (String dataSourceName : dataSourceNames) {
                result.add(new DataNode(dataSourceName, actualTable));
            }
        }
        return result;
    }

    private Collection<String> getDataSourceNames(DataSourceRule dataSourceRule, Collection<String> actualDataSourceNames) {
        if (null == dataSourceRule) {
            return Collections.emptyList();
        }
        if (null == actualDataSourceNames || actualDataSourceNames.isEmpty()) {
            return dataSourceRule.getDataSourceNames();
        }
        return actualDataSourceNames;
    }

    public Collection<DataNode> getActualDataNodes(Collection<String> targetDataSources, Collection<String> targetTables) {
        return this.dynamic ? this.getDynamicDataNodes(targetDataSources, targetTables) : this.getStaticDataNodes(targetDataSources, targetTables);
    }

    private Collection<DataNode> getDynamicDataNodes(Collection<String> targetDataSources, Collection<String> targetTables) {
        LinkedHashSet<DataNode> result = new LinkedHashSet<DataNode>(targetDataSources.size() * targetTables.size());
        for (String targetDataSource : targetDataSources) {
            for (String targetTable : targetTables) {
                result.add(new DataNode(targetDataSource, targetTable));
            }
        }
        return result;
    }

    private Collection<DataNode> getStaticDataNodes(Collection<String> targetDataSources, Collection<String> targetTables) {
        LinkedHashSet<DataNode> result = new LinkedHashSet<DataNode>(this.actualTables.size());
        for (DataNode each : this.actualTables) {
            if (!targetDataSources.contains(each.getDataSourceName()) || !targetTables.contains(each.getTableName())) continue;
            result.add(each);
        }
        return result;
    }

    public Collection<String> getActualDatasourceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.actualTables.size());
        for (DataNode each : this.actualTables) {
            result.add(each.getDataSourceName());
        }
        return result;
    }

    public Collection<String> getActualTableNames(Collection<String> targetDataSources) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.actualTables.size());
        for (DataNode each : this.actualTables) {
            if (!targetDataSources.contains(each.getDataSourceName())) continue;
            result.add(each.getTableName());
        }
        return result;
    }

    int findActualTableIndex(String dataSourceName, String actualTableName) {
        int result = 0;
        for (DataNode each : this.actualTables) {
            if (each.getDataSourceName().equals(dataSourceName) && each.getTableName().equals(actualTableName)) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    void fillIdGenerator(Class<? extends IdGenerator> idGeneratorClass) {
        for (Map.Entry<String, IdGenerator> each : this.autoIncrementColumnMap.entrySet()) {
            if (null != each.getValue()) continue;
            IdGenerator idGenerator = TableRuleBuilder.instanceIdGenerator(idGeneratorClass);
            each.setValue(idGenerator);
        }
    }

    public Object generateId(String columnName) {
        Number result = this.autoIncrementColumnMap.get(columnName).generateId();
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public String getLogicTable() {
        return this.logicTable;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public List<DataNode> getActualTables() {
        return this.actualTables;
    }

    public DatabaseShardingStrategy getDatabaseShardingStrategy() {
        return this.databaseShardingStrategy;
    }

    public TableShardingStrategy getTableShardingStrategy() {
        return this.tableShardingStrategy;
    }

    public String toString() {
        return "TableRule(logicTable=" + this.getLogicTable() + ", dynamic=" + this.isDynamic() + ", actualTables=" + this.getActualTables() + ", databaseShardingStrategy=" + this.getDatabaseShardingStrategy() + ", tableShardingStrategy=" + this.getTableShardingStrategy() + ", autoIncrementColumnMap=" + this.getAutoIncrementColumnMap() + ")";
    }

    Map<String, IdGenerator> getAutoIncrementColumnMap() {
        return this.autoIncrementColumnMap;
    }

    public static class TableRuleBuilder {
        private final String logicTable;
        private boolean dynamic;
        private List<String> actualTables;
        private DataSourceRule dataSourceRule;
        private Collection<String> dataSourceNames;
        private DatabaseShardingStrategy databaseShardingStrategy;
        private TableShardingStrategy tableShardingStrategy;
        private final Map<String, IdGenerator> autoIncrementColumnMap = new LinkedHashMap<String, IdGenerator>();
        private Class<? extends IdGenerator> tableIdGeneratorClass;

        static IdGenerator instanceIdGenerator(Class<? extends IdGenerator> idGeneratorClass) {
            Preconditions.checkNotNull(idGeneratorClass);
            try {
                return idGeneratorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(String.format("Class %s should have public privilege and no argument constructor", idGeneratorClass.getName()));
            }
        }

        public TableRuleBuilder dynamic(boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public TableRuleBuilder actualTables(List<String> actualTables) {
            this.actualTables = actualTables;
            return this;
        }

        public TableRuleBuilder dataSourceRule(DataSourceRule dataSourceRule) {
            this.dataSourceRule = dataSourceRule;
            return this;
        }

        public TableRuleBuilder dataSourceNames(Collection<String> dataSourceNames) {
            this.dataSourceNames = dataSourceNames;
            return this;
        }

        public TableRuleBuilder databaseShardingStrategy(DatabaseShardingStrategy databaseShardingStrategy) {
            this.databaseShardingStrategy = databaseShardingStrategy;
            return this;
        }

        public TableRuleBuilder tableShardingStrategy(TableShardingStrategy tableShardingStrategy) {
            this.tableShardingStrategy = tableShardingStrategy;
            return this;
        }

        public TableRuleBuilder autoIncrementColumns(String autoIncrementColumn) {
            this.autoIncrementColumnMap.put(autoIncrementColumn, null);
            return this;
        }

        public TableRuleBuilder autoIncrementColumns(String autoIncrementColumn, Class<? extends IdGenerator> columnIdGeneratorClass) {
            this.autoIncrementColumnMap.put(autoIncrementColumn, TableRuleBuilder.instanceIdGenerator(columnIdGeneratorClass));
            return this;
        }

        public TableRuleBuilder tableIdGenerator(Class<? extends IdGenerator> tableIdGeneratorClass) {
            this.tableIdGeneratorClass = tableIdGeneratorClass;
            return this;
        }

        public TableRule build() {
            TableRule result = new TableRule(this.logicTable, this.dynamic, this.actualTables, this.dataSourceRule, this.dataSourceNames, this.databaseShardingStrategy, this.tableShardingStrategy);
            result.autoIncrementColumnMap.putAll(this.autoIncrementColumnMap);
            if (null == this.tableIdGeneratorClass) {
                return result;
            }
            result.fillIdGenerator(this.tableIdGeneratorClass);
            return result;
        }

        @ConstructorProperties(value={"logicTable"})
        public TableRuleBuilder(String logicTable) {
            this.logicTable = logicTable;
        }
    }
}

