/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.executor;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.executor.EventPostman;
import com.dangdang.ddframe.rdb.sharding.executor.ExecuteUnit;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorDataMap;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorEngine;
import com.dangdang.ddframe.rdb.sharding.executor.ExecutorExceptionHandler;
import com.dangdang.ddframe.rdb.sharding.executor.MergeUnit;
import com.dangdang.ddframe.rdb.sharding.executor.event.EventExecutionType;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.StatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class StatementExecutor {
    private final ExecutorEngine executorEngine;
    private final Collection<StatementExecutorWrapper> statementExecutorWrappers = new ArrayList<StatementExecutorWrapper>();
    private final EventPostman eventPostman = new EventPostman(this.statementExecutorWrappers);

    public void addStatement(StatementExecutorWrapper statementExecutorWrapper) {
        this.statementExecutorWrappers.add(statementExecutorWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSet> executeQuery() {
        List<ResultSet> result;
        Timer.Context context = MetricsContext.start("ShardingStatement-executeQuery");
        this.eventPostman.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.statementExecutorWrappers.size()) {
                List<ResultSet> list = Collections.singletonList(this.executeQueryInternal(this.statementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap));
                return list;
            }
            result = this.executorEngine.execute(this.statementExecutorWrappers, new ExecuteUnit<StatementExecutorWrapper, ResultSet>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ResultSet execute(StatementExecutorWrapper input) throws Exception {
                    Connection connection = input.getStatement().getConnection();
                    synchronized (connection) {
                        return StatementExecutor.this.executeQueryInternal(input, isExceptionThrown, dataMap);
                    }
                }
            });
        }
        finally {
            MetricsContext.stop(context);
        }
        return result;
    }

    private ResultSet executeQueryInternal(StatementExecutorWrapper statementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        ResultSet result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = statementExecutorWrapper.getStatement().executeQuery(statementExecutorWrapper.getSqlExecutionUnit().getSql());
        }
        catch (SQLException ex) {
            this.eventPostman.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
        this.eventPostman.postExecutionEventsAfterExecution(statementExecutorWrapper);
        return result;
    }

    public int executeUpdate() {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql);
            }
        });
    }

    public int executeUpdate(final int autoGeneratedKeys) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    public int executeUpdate(final int[] columnIndexes) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnIndexes);
            }
        });
    }

    public int executeUpdate(final String[] columnNames) {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnNames);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(final Updater updater) {
        Timer.Context context = MetricsContext.start("ShardingStatement-executeUpdate");
        this.eventPostman.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.statementExecutorWrappers.size()) {
                int n = this.executeUpdateInternal(updater, this.statementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap);
                return n;
            }
            int n = this.executorEngine.execute(this.statementExecutorWrappers, new ExecuteUnit<StatementExecutorWrapper, Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer execute(StatementExecutorWrapper input) throws Exception {
                    Connection connection = input.getStatement().getConnection();
                    synchronized (connection) {
                        return StatementExecutor.this.executeUpdateInternal(updater, input, isExceptionThrown, dataMap);
                    }
                }
            }, new MergeUnit<Integer, Integer>(){

                @Override
                public Integer merge(List<Integer> results) {
                    if (null == results) {
                        return 0;
                    }
                    int result = 0;
                    for (int each : results) {
                        result += each;
                    }
                    return result;
                }
            });
            return n;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private int executeUpdateInternal(Updater updater, StatementExecutorWrapper statementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        int result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = updater.executeUpdate(statementExecutorWrapper.getStatement(), statementExecutorWrapper.getSqlExecutionUnit().getSql());
        }
        catch (SQLException ex) {
            this.eventPostman.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return 0;
        }
        this.eventPostman.postExecutionEventsAfterExecution(statementExecutorWrapper);
        return result;
    }

    public boolean execute() {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql);
            }
        });
    }

    public boolean execute(final int autoGeneratedKeys) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, autoGeneratedKeys);
            }
        });
    }

    public boolean execute(final int[] columnIndexes) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnIndexes);
            }
        });
    }

    public boolean execute(final String[] columnNames) {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnNames);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(final Executor executor) {
        Timer.Context context = MetricsContext.start("ShardingStatement-execute");
        this.eventPostman.postExecutionEvents();
        final boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        final Map<String, Object> dataMap = ExecutorDataMap.getDataMap();
        try {
            if (1 == this.statementExecutorWrappers.size()) {
                boolean bl = this.executeInternal(executor, this.statementExecutorWrappers.iterator().next(), isExceptionThrown, dataMap);
                return bl;
            }
            List<Boolean> result = this.executorEngine.execute(this.statementExecutorWrappers, new ExecuteUnit<StatementExecutorWrapper, Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean execute(StatementExecutorWrapper input) throws Exception {
                    Connection connection = input.getStatement().getConnection();
                    synchronized (connection) {
                        return StatementExecutor.this.executeInternal(executor, input, isExceptionThrown, dataMap);
                    }
                }
            });
            boolean bl = null == result || result.isEmpty() ? false : result.get(0);
            return bl;
        }
        finally {
            MetricsContext.stop(context);
        }
    }

    private boolean executeInternal(Executor executor, StatementExecutorWrapper statementExecutorWrapper, boolean isExceptionThrown, Map<String, Object> dataMap) {
        boolean result;
        ExecutorExceptionHandler.setExceptionThrown(isExceptionThrown);
        ExecutorDataMap.setDataMap(dataMap);
        try {
            result = executor.execute(statementExecutorWrapper.getStatement(), statementExecutorWrapper.getSqlExecutionUnit().getSql());
        }
        catch (SQLException ex) {
            this.eventPostman.postExecutionEventsAfterExecution(statementExecutorWrapper, EventExecutionType.EXECUTE_FAILURE, (Optional<SQLException>)Optional.of((Object)ex));
            ExecutorExceptionHandler.handleException(ex);
            return false;
        }
        this.eventPostman.postExecutionEventsAfterExecution(statementExecutorWrapper);
        return result;
    }

    @ConstructorProperties(value={"executorEngine"})
    public StatementExecutor(ExecutorEngine executorEngine) {
        this.executorEngine = executorEngine;
    }

    private static interface Executor {
        public boolean execute(Statement var1, String var2) throws SQLException;
    }

    private static interface Updater {
        public int executeUpdate(Statement var1, String var2) throws SQLException;
    }
}

