/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.dangdang.ddframe.rdb.sharding.jdbc.GeneratedKeysResultSetMetaData;
import com.dangdang.ddframe.rdb.sharding.jdbc.unsupported.AbstractUnsupportedGeneratedKeysResultSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class GeneratedKeysResultSet
extends AbstractUnsupportedGeneratedKeysResultSet {
    private final Table<Integer, Integer, Object> valueTable;
    private final Map<String, Integer> columnNameToIndexMap;
    private final Statement statement;
    private boolean isClosed;
    private int rowIndex = -1;

    public GeneratedKeysResultSet() {
        this.valueTable = TreeBasedTable.create();
        this.columnNameToIndexMap = new HashMap<String, Integer>();
        this.statement = null;
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        ++this.rowIndex;
        return this.rowIndex + 1 <= this.valueTable.rowKeySet().size();
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        return new GeneratedKeysResultSetMetaData(this.valueTable, this.columnNameToIndexMap);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkState();
        return false;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkState();
        return this.valueTable.get((Object)this.rowIndex, (Object)(columnIndex - 1)).toString();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkState();
        return this.valueTable.get((Object)this.rowIndex, (Object)this.findColumn(columnLabel)).toString();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkState();
        return this.getNumberValue(columnIndex - 1).byteValue();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkState();
        return this.getNumberValue(this.findColumn(columnLabel)).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkState();
        return this.getNumberValue(columnIndex - 1).shortValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkState();
        return this.getNumberValue(this.findColumn(columnLabel)).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkState();
        return this.getNumberValue(columnIndex - 1).intValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkState();
        return this.getNumberValue(this.findColumn(columnLabel)).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkState();
        return this.getNumberValue(columnIndex - 1).longValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkState();
        return this.getNumberValue(this.findColumn(columnLabel)).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkState();
        return this.getNumberValue(columnIndex - 1).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkState();
        return this.getNumberValue(this.findColumn(columnLabel)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkState();
        return this.getNumberValue(columnIndex - 1).doubleValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkState();
        return this.getNumberValue(this.findColumn(columnLabel)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkState();
        return new BigDecimal(this.getNumberValue(columnIndex - 1).longValue()).setScale(scale, 4);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkState();
        return new BigDecimal(this.getNumberValue(this.findColumn(columnLabel)).longValue()).setScale(scale, 4);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkState();
        return new BigDecimal(this.getNumberValue(columnIndex - 1).longValue());
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkState();
        return new BigDecimal(this.getNumberValue(this.findColumn(columnLabel)).longValue());
    }

    private Number getNumberValue(int columnIndex) {
        Object value = this.valueTable.get((Object)this.rowIndex, (Object)columnIndex);
        Preconditions.checkState((boolean)(value instanceof Number));
        return (Number)value;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkState();
        return this.getString(columnIndex).getBytes();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkState();
        return this.getString(columnLabel).getBytes();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkState();
        return this.valueTable.get((Object)this.rowIndex, (Object)(columnIndex - 1));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkState();
        return this.valueTable.get((Object)this.rowIndex, (Object)this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkState();
        return this.columnNameToIndexMap.get(columnLabel);
    }

    @Override
    public int getType() throws SQLException {
        this.checkState();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkState();
        return 1007;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkState();
        return this.statement;
    }

    private void checkState() throws SQLException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"ResultSet has closed");
    }

    @ConstructorProperties(value={"valueTable", "columnNameToIndexMap", "statement"})
    public GeneratedKeysResultSet(Table<Integer, Integer, Object> valueTable, Map<String, Integer> columnNameToIndexMap, Statement statement) {
        this.valueTable = valueTable;
        this.columnNameToIndexMap = columnNameToIndexMap;
        this.statement = statement;
    }
}

