/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

class GeneratedKeysResultSetMetaData
implements ResultSetMetaData {
    private final Map<Integer, String> indexToColumnNameMap = new HashMap<Integer, String>();
    private final Table<Integer, Integer, Object> autoIncrementValueTable;

    GeneratedKeysResultSetMetaData(Table<Integer, Integer, Object> autoIncrementValueTable, Map<String, Integer> autoIncrementColumnNameToIndexMap) {
        this.autoIncrementValueTable = autoIncrementValueTable;
        for (Map.Entry<String, Integer> each : autoIncrementColumnNameToIndexMap.entrySet()) {
            this.indexToColumnNameMap.put(each.getValue(), each.getKey());
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.indexToColumnNameMap.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkIndex(column);
        return true;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkIndex(column);
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkIndex(column);
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkIndex(column);
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkIndex(column);
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkIndex(column);
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkIndex(column);
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkIndex(column);
        return this.indexToColumnNameMap.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkIndex(column);
        return this.indexToColumnNameMap.get(column - 1);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkIndex(column);
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkIndex(column);
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkIndex(column);
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkIndex(column);
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkIndex(column);
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkIndex(column);
        Object value = this.autoIncrementValueTable.get((Object)0, (Object)(column - 1));
        return value instanceof Number ? -5 : 12;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkIndex(column);
        return "";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkIndex(column);
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkIndex(column);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkIndex(column);
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkIndex(column);
        Object value = this.autoIncrementValueTable.get((Object)0, (Object)(column - 1));
        return value.getClass().getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(String.format("[%s] cannot be unwrapped as [%s]", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private void checkIndex(int column) {
        Preconditions.checkArgument((column >= 1 && column <= this.indexToColumnNameMap.size() ? 1 : 0) != 0);
    }
}

