/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.dangdang.ddframe.rdb.sharding.executor.PreparedStatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.event.DMLExecutionEvent;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.BatchPreparedStatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.executor.wrapper.PreparedStatementExecutorWrapper;
import com.dangdang.ddframe.rdb.sharding.jdbc.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractPreparedStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.util.ParameterList;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetFactory;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.MergeContext;
import com.dangdang.ddframe.rdb.sharding.router.PreparedSQLRouter;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ShardingPreparedStatement
extends AbstractPreparedStatementAdapter {
    private final PreparedSQLRouter preparedSQLRouter;
    private final Map<PreparedStatement, PreparedStatementExecutorWrapper> cachedRoutePreparedStatementMap = new HashMap<PreparedStatement, PreparedStatementExecutorWrapper>();
    private Integer autoGeneratedKeys;
    private int[] columnIndexes;
    private String[] columnNames;

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql) {
        this(shardingConnection, sql, 1003, 1007, 1);
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency) {
        this(shardingConnection, sql, resultSetType, resultSetConcurrency, 1);
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(shardingConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.preparedSQLRouter = shardingConnection.getShardingContext().getSqlRouteEngine().prepareSQL(sql);
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int autoGeneratedKeys) {
        this(shardingConnection, sql);
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, int[] columnIndexes) {
        this(shardingConnection, sql);
        this.columnIndexes = columnIndexes;
    }

    ShardingPreparedStatement(ShardingConnection shardingConnection, String sql, String[] columnNames) {
        this(shardingConnection, sql);
        this.columnNames = columnNames;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet rs;
        try {
            rs = ResultSetFactory.getResultSet(new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.routeSQL()).executeQuery(), this.getMergeContext());
        }
        finally {
            this.clearRouteContext();
        }
        this.setCurrentResultSet(rs);
        return rs;
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            int n = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.routeSQL()).executeUpdate();
            return n;
        }
        finally {
            this.clearRouteContext();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            boolean bl = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.routeSQL()).execute();
            return bl;
        }
        finally {
            this.clearRouteContext();
        }
    }

    @Override
    protected void clearRouteContext() throws SQLException {
        super.clearRouteContext();
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            for (PreparedStatementExecutorWrapper each : this.routeSQL()) {
                BatchPreparedStatementExecutorWrapper wrapper;
                each.getPreparedStatement().addBatch();
                if (this.cachedRoutePreparedStatementMap.containsKey(each.getPreparedStatement())) {
                    wrapper = (BatchPreparedStatementExecutorWrapper)this.cachedRoutePreparedStatementMap.get(each.getPreparedStatement());
                } else {
                    wrapper = new BatchPreparedStatementExecutorWrapper(each.getPreparedStatement(), this.getParameters(), each.getSqlExecutionUnit());
                    this.cachedRoutePreparedStatementMap.put(each.getPreparedStatement(), wrapper);
                }
                if (!each.getDMLExecutionEvent().isPresent()) continue;
                wrapper.getDmlExecutionEvents().add((DMLExecutionEvent)each.getDMLExecutionEvent().get());
            }
            this.getGeneratedKeyContext().addRow();
        }
        finally {
            this.clearRouteContext();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.cachedRoutePreparedStatementMap.clear();
        this.clearRouteContext();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = new PreparedStatementExecutor(this.getShardingConnection().getShardingContext().getExecutorEngine(), this.cachedRoutePreparedStatementMap.values()).executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private List<PreparedStatementExecutorWrapper> routeSQL() throws SQLException {
        ParameterList parameters = this.getParameters();
        ArrayList<PreparedStatementExecutorWrapper> result = new ArrayList<PreparedStatementExecutorWrapper>();
        SQLRouteResult sqlRouteResult = this.preparedSQLRouter.route(this.getParameters());
        MergeContext mergeContext = sqlRouteResult.getMergeContext();
        this.setMergeContext(mergeContext);
        this.setGeneratedKeyContext(sqlRouteResult.getGeneratedKeyContext());
        for (SQLExecutionUnit each : sqlRouteResult.getExecutionUnits()) {
            PreparedStatement preparedStatement = (PreparedStatement)this.getStatement(this.getShardingConnection().getConnection(each.getDataSource(), sqlRouteResult.getSqlStatementType()), each.getSql());
            this.replayMethodsInvocation(preparedStatement);
            this.getParameters().replayMethodsInvocation(preparedStatement);
            result.add(new PreparedStatementExecutorWrapper(preparedStatement, parameters, each));
        }
        return result;
    }

    @Override
    protected PreparedStatement generateStatement(Connection conn, String shardingSql) throws SQLException {
        if (null != this.autoGeneratedKeys) {
            this.getGeneratedKeyContext().setAutoGeneratedKeys(this.autoGeneratedKeys);
            return conn.prepareStatement(shardingSql, this.autoGeneratedKeys);
        }
        if (null != this.columnIndexes) {
            this.getGeneratedKeyContext().setColumnIndexes(this.columnIndexes);
            return conn.prepareStatement(shardingSql, this.columnIndexes);
        }
        if (null != this.columnNames) {
            this.getGeneratedKeyContext().setColumnNames(this.columnNames);
            return conn.prepareStatement(shardingSql, this.columnNames);
        }
        if (0 != this.getResultSetHoldability()) {
            return conn.prepareStatement(shardingSql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
        }
        return conn.prepareStatement(shardingSql, this.getResultSetType(), this.getResultSetConcurrency());
    }
}

