/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.util;

import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class JdbcMethodInvocation {
    private final Method method;
    private final Object[] arguments;

    public void invoke(Object target) {
        try {
            this.method.invoke(target, this.arguments);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new ShardingJdbcException("Invoke jdbc method exception", ex);
        }
    }

    @ConstructorProperties(value={"method", "arguments"})
    public JdbcMethodInvocation(Method method, Object[] arguments) {
        this.method = method;
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

