/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.result;

import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GeneratedKeyContext {
    private final List<String> columns = new LinkedList<String>();
    private final Map<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();
    private final Table<Integer, Integer, Object> valueTable = TreeBasedTable.create();
    private int rowIndex;
    private int columnIndex;
    private int autoGeneratedKeys;
    private int[] columnIndexes;
    private String[] columnNames;

    public void putValue(String columnName, Object value) {
        this.valueTable.put((Object)this.rowIndex, (Object)this.columnIndex, value);
        this.columnNameToIndexMap.put(columnName, this.columnIndex);
        ++this.columnIndex;
    }

    public void addRow() {
        ++this.rowIndex;
        this.columnIndex = 0;
    }

    public String toString() {
        return "GeneratedKeyContext(columns=" + this.getColumns() + ", columnNameToIndexMap=" + this.getColumnNameToIndexMap() + ", valueTable=" + this.getValueTable() + ", rowIndex=" + this.rowIndex + ", columnIndex=" + this.columnIndex + ", autoGeneratedKeys=" + this.getAutoGeneratedKeys() + ", columnIndexes=" + Arrays.toString(this.getColumnIndexes()) + ", columnNames=" + Arrays.deepToString(this.getColumnNames()) + ")";
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public Map<String, Integer> getColumnNameToIndexMap() {
        return this.columnNameToIndexMap;
    }

    public Table<Integer, Integer, Object> getValueTable() {
        return this.valueTable;
    }

    public void setAutoGeneratedKeys(int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public void setColumnIndexes(int[] columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }
}

