/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.result.router;

import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ConditionContext {
    private final Map<Condition.Column, Condition> conditions = new LinkedHashMap<Condition.Column, Condition>();

    public void add(Condition condition) {
        this.conditions.put(condition.getColumn(), condition);
    }

    public Optional<Condition> find(String table, String column) {
        return Optional.fromNullable((Object)this.conditions.get(new Condition.Column(column, table)));
    }

    public Optional<Condition> find(String table, String column, Condition.BinaryOperator operator) {
        Optional result = this.find(table, column);
        if (!result.isPresent()) {
            return result;
        }
        return ((Condition)result.get()).getOperator() == operator ? result : Optional.absent();
    }

    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    public void clear() {
        this.conditions.clear();
    }

    public Collection<Condition> getAllConditions() {
        return this.conditions.values();
    }

    public void setNewConditionValue(List<Object> parameters) {
        for (Condition each : this.conditions.values()) {
            if (each.getValueIndices().isEmpty()) continue;
            for (int i = 0; i < each.getValueIndices().size(); ++i) {
                Object value = parameters.get(each.getValueIndices().get(i));
                if (value instanceof Comparable) {
                    each.getValues().set(i, (Comparable)value);
                    continue;
                }
                each.getValues().set(i, (Comparable<?>)((Object)""));
            }
        }
    }

    public String toString() {
        return "ConditionContext(conditions=" + this.conditions + ")";
    }
}

