/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.mixed;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.router.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.binding.BindingTablesRouter;
import com.dangdang.ddframe.rdb.sharding.router.mixed.CartesianTablesRouter;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleTableRouter;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedTablesRouter {
    private static final Logger log = LoggerFactory.getLogger(MixedTablesRouter.class);
    private final ShardingRule shardingRule;
    private final Collection<String> logicTables;
    private final ConditionContext conditionContext;
    private final SQLStatementType sqlStatementType;

    public RoutingResult route() {
        Collection<String> bindingTables = this.shardingRule.filterAllBindingTables(this.logicTables);
        ArrayList<String> remainingTables = new ArrayList<String>(this.logicTables);
        ArrayList<SingleRoutingResult> result = new ArrayList<SingleRoutingResult>(this.logicTables.size());
        if (1 < bindingTables.size()) {
            result.add(new BindingTablesRouter(this.shardingRule, bindingTables, this.conditionContext, this.sqlStatementType).route());
            remainingTables.removeAll(bindingTables);
        }
        for (String each : remainingTables) {
            SingleRoutingResult routingResult = new SingleTableRouter(this.shardingRule, each, this.conditionContext, this.sqlStatementType).route();
            if (null == routingResult) continue;
            result.add(routingResult);
        }
        log.trace("mixed tables sharding result: {}", result);
        if (result.isEmpty()) {
            return null;
        }
        if (1 == result.size()) {
            return (RoutingResult)result.iterator().next();
        }
        return new CartesianTablesRouter(result).route();
    }

    @ConstructorProperties(value={"shardingRule", "logicTables", "conditionContext", "sqlStatementType"})
    public MixedTablesRouter(ShardingRule shardingRule, Collection<String> logicTables, ConditionContext conditionContext, SQLStatementType sqlStatementType) {
        this.shardingRule = shardingRule;
        this.logicTables = logicTables;
        this.conditionContext = conditionContext;
        this.sqlStatementType = sqlStatementType;
    }
}

