/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.single;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataNode;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataSourceRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.NoneDatabaseShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.NoneTableShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.TableShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.hint.ShardingKey;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Condition;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRouterUtil;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingTableFactor;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleTableRouter {
    private static final Logger log = LoggerFactory.getLogger(SingleTableRouter.class);
    private final ShardingRule shardingRule;
    private final String logicTable;
    private final ConditionContext conditionContext;
    private final TableRule tableRule;
    private final SQLStatementType sqlStatementType;

    public SingleTableRouter(ShardingRule shardingRule, String logicTable, ConditionContext conditionContext, SQLStatementType sqlStatementType) {
        this.shardingRule = shardingRule;
        this.logicTable = logicTable;
        this.conditionContext = conditionContext;
        this.sqlStatementType = sqlStatementType;
        Optional<TableRule> tableRuleOptional = shardingRule.tryFindTableRule(logicTable);
        if (tableRuleOptional.isPresent()) {
            this.tableRule = (TableRule)tableRuleOptional.get();
        } else if (shardingRule.getDataSourceRule().getDefaultDataSource().isPresent()) {
            this.tableRule = this.createTableRuleWithDefaultDataSource(logicTable, shardingRule.getDataSourceRule());
        } else {
            throw new IllegalArgumentException(String.format("Cannot find table rule and default data source with logic table: '%s'", logicTable));
        }
    }

    private TableRule createTableRuleWithDefaultDataSource(String logicTable, DataSourceRule defaultDataSourceRule) {
        HashMap<String, DataSource> defaultDataSourceMap = new HashMap<String, DataSource>(1);
        defaultDataSourceMap.put(defaultDataSourceRule.getDefaultDataSourceName(), (DataSource)defaultDataSourceRule.getDefaultDataSource().get());
        return TableRule.builder(logicTable).dataSourceRule(new DataSourceRule(defaultDataSourceMap)).databaseShardingStrategy(new DatabaseShardingStrategy("", new NoneDatabaseShardingAlgorithm())).tableShardingStrategy(new TableShardingStrategy("", new NoneTableShardingAlgorithm())).build();
    }

    public SingleRoutingResult route() {
        Collection<String> routedDataSources = this.routeDataSources();
        Collection<String> routedTables = this.routeTables(routedDataSources);
        return this.generateRoutingResult(routedDataSources, routedTables);
    }

    private Collection<String> routeDataSources() {
        DatabaseShardingStrategy strategy = this.shardingRule.getDatabaseShardingStrategy(this.tableRule);
        List<ShardingValue<?>> shardingValues = HintManagerHolder.isUseShardingHint() ? this.getDatabaseShardingValuesFromHint(strategy.getShardingColumns()) : this.getShardingValues(strategy.getShardingColumns());
        this.logBeforeRoute("database", this.logicTable, this.tableRule.getActualDatasourceNames(), strategy.getShardingColumns(), shardingValues);
        HashSet<String> result = new HashSet<String>(strategy.doStaticSharding(this.sqlStatementType, this.tableRule.getActualDatasourceNames(), shardingValues));
        this.logAfterRoute("database", this.logicTable, result);
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        return result;
    }

    private Collection<String> routeTables(Collection<String> routedDataSources) {
        TableShardingStrategy strategy = this.shardingRule.getTableShardingStrategy(this.tableRule);
        List<ShardingValue<?>> shardingValues = HintManagerHolder.isUseShardingHint() ? this.getTableShardingValuesFromHint(strategy.getShardingColumns()) : this.getShardingValues(strategy.getShardingColumns());
        this.logBeforeRoute("table", this.logicTable, this.tableRule.getActualTables(), strategy.getShardingColumns(), shardingValues);
        HashSet<String> result = this.tableRule.isDynamic() ? new HashSet<String>(strategy.doDynamicSharding(shardingValues)) : new HashSet<String>(strategy.doStaticSharding(this.sqlStatementType, this.tableRule.getActualTableNames(routedDataSources), shardingValues));
        this.logAfterRoute("table", this.logicTable, result);
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no table route info");
        return result;
    }

    private List<ShardingValue<?>> getDatabaseShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList result = new ArrayList(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue<?>> shardingValue = HintManagerHolder.getDatabaseShardingValue(new ShardingKey(this.logicTable, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue<?>)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue<?>> getTableShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList result = new ArrayList(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue<?>> shardingValue = HintManagerHolder.getTableShardingValue(new ShardingKey(this.logicTable, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue<?>)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue<?>> getShardingValues(Collection<String> shardingColumns) {
        ArrayList result = new ArrayList(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<Condition> condition = this.conditionContext.find(this.logicTable, each);
            if (!condition.isPresent()) continue;
            result.add(SingleRouterUtil.convertConditionToShardingValue((Condition)condition.get()));
        }
        return result;
    }

    private void logBeforeRoute(String type, String logicTable, Collection<?> targets, Collection<String> shardingColumns, List<ShardingValue<?>> shardingValues) {
        log.debug("Before {} sharding {} routes db names: {} sharding columns: {} sharding values: {}", new Object[]{type, logicTable, targets, shardingColumns, shardingValues});
    }

    private void logAfterRoute(String type, String logicTable, Collection<String> shardingResults) {
        log.debug("After {} sharding {} result: {}", new Object[]{type, logicTable, shardingResults});
    }

    private SingleRoutingResult generateRoutingResult(Collection<String> routedDataSources, Collection<String> routedTables) {
        SingleRoutingResult result = new SingleRoutingResult();
        for (DataNode each : this.tableRule.getActualDataNodes(routedDataSources, routedTables)) {
            result.put(each.getDataSourceName(), new SingleRoutingTableFactor(this.logicTable, each.getTableName()));
        }
        return result;
    }
}

