/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api.rule;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;

public final class DataSourceRule {
    private final Map<String, DataSource> dataSourceMap;
    private final String defaultDataSourceName;

    public DataSourceRule(Map<String, DataSource> dataSourceMap) {
        this(dataSourceMap, null);
    }

    public DataSourceRule(Map<String, DataSource> dataSourceMap, String defaultDataSourceName) {
        Preconditions.checkState((!dataSourceMap.isEmpty() ? 1 : 0) != 0, (Object)"Must have one data source at least.");
        this.dataSourceMap = dataSourceMap;
        if (1 == dataSourceMap.size()) {
            this.defaultDataSourceName = dataSourceMap.entrySet().iterator().next().getKey();
            return;
        }
        if (Strings.isNullOrEmpty((String)defaultDataSourceName)) {
            this.defaultDataSourceName = null;
            return;
        }
        Preconditions.checkState((boolean)dataSourceMap.containsKey(defaultDataSourceName), (Object)"Data source rule must include default data source.");
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public DataSource getDataSource(String name) {
        return this.dataSourceMap.get(name);
    }

    public Optional<DataSource> getDefaultDataSource() {
        return Optional.fromNullable((Object)this.dataSourceMap.get(this.defaultDataSourceName));
    }

    public Collection<String> getDataSourceNames() {
        return this.dataSourceMap.keySet();
    }

    public Collection<DataSource> getDataSources() {
        return this.dataSourceMap.values();
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }
}

