/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger;

import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.groupby.GroupByMemoryResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.groupby.GroupByStreamResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.iterator.IteratorStreamResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.limit.LimitDecoratorResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.orderby.OrderByStreamResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class MergeEngine {
    private final DatabaseType databaseType;
    private final List<ResultSet> resultSets;
    private final SelectStatement selectStatement;
    private final Map<String, Integer> columnLabelIndexMap;

    public MergeEngine(DatabaseType databaseType, List<ResultSet> resultSets, SelectStatement selectStatement) throws SQLException {
        this.databaseType = databaseType;
        this.resultSets = resultSets;
        this.selectStatement = selectStatement;
        this.columnLabelIndexMap = this.getColumnLabelIndexMap(resultSets.get(0));
    }

    private Map<String, Integer> getColumnLabelIndexMap(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            result.put(SQLUtil.getExactlyValue(resultSetMetaData.getColumnLabel(i)), i);
        }
        return result;
    }

    public ResultSetMerger merge() throws SQLException {
        this.selectStatement.setIndexForItems(this.columnLabelIndexMap);
        return this.decorate(this.build());
    }

    private ResultSetMerger build() throws SQLException {
        if (!this.selectStatement.getGroupByItems().isEmpty() || !this.selectStatement.getAggregationSelectItems().isEmpty()) {
            if (this.selectStatement.isSameGroupByAndOrderByItems()) {
                return new GroupByStreamResultSetMerger(this.columnLabelIndexMap, this.resultSets, this.selectStatement, this.getNullOrderType());
            }
            return new GroupByMemoryResultSetMerger(this.columnLabelIndexMap, this.resultSets, this.selectStatement, this.getNullOrderType());
        }
        if (!this.selectStatement.getOrderByItems().isEmpty()) {
            return new OrderByStreamResultSetMerger(this.resultSets, this.selectStatement.getOrderByItems(), this.getNullOrderType());
        }
        return new IteratorStreamResultSetMerger(this.resultSets);
    }

    private ResultSetMerger decorate(ResultSetMerger resultSetMerger) throws SQLException {
        ResultSetMerger result = resultSetMerger;
        if (null != this.selectStatement.getLimit()) {
            result = new LimitDecoratorResultSetMerger(result, this.selectStatement.getLimit());
        }
        return result;
    }

    private OrderType getNullOrderType() {
        if (DatabaseType.MySQL == this.databaseType || DatabaseType.Oracle == this.databaseType || DatabaseType.H2 == this.databaseType) {
            return OrderType.ASC;
        }
        return OrderType.DESC;
    }
}

