/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.groupby.aggregation;

import com.dangdang.ddframe.rdb.sharding.merger.groupby.aggregation.AggregationUnit;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AverageAggregationUnit
implements AggregationUnit {
    private static final Logger log = LoggerFactory.getLogger(AverageAggregationUnit.class);
    private BigDecimal count;
    private BigDecimal sum;

    @Override
    public void merge(List<Comparable<?>> values) {
        if (null == values || null == values.get(0) || null == values.get(1)) {
            return;
        }
        if (null == this.count) {
            this.count = new BigDecimal("0");
        }
        if (null == this.sum) {
            this.sum = new BigDecimal("0");
        }
        this.count = this.count.add(new BigDecimal(values.get(0).toString()));
        this.sum = this.sum.add(new BigDecimal(values.get(1).toString()));
        log.trace("AVG result COUNT: {} SUM: {}", (Object)this.count, (Object)this.sum);
    }

    @Override
    public Comparable<?> getResult() {
        if (null == this.count || BigDecimal.ZERO.equals(this.count)) {
            return this.count;
        }
        return this.sum.divide(this.count, 4, 4);
    }
}

