/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.Lexer;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.analyzer.Dictionary;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Assist;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.TokenType;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.delete.DeleteStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.update.UpdateStatement;
import java.beans.ConstructorProperties;

public final class SQLJudgeEngine {
    private final String sql;

    public SQLStatement judge() {
        Lexer lexer = new Lexer(this.sql, new Dictionary(new Keyword[0]));
        lexer.nextToken();
        while (true) {
            TokenType tokenType;
            if ((tokenType = lexer.getCurrentToken().getType()) instanceof Keyword) {
                if (DefaultKeyword.SELECT == tokenType) {
                    return new SelectStatement();
                }
                if (DefaultKeyword.UPDATE == tokenType) {
                    return new UpdateStatement();
                }
                if (DefaultKeyword.INSERT == tokenType) {
                    return new InsertStatement();
                }
                if (DefaultKeyword.DELETE == tokenType) {
                    return new DeleteStatement();
                }
            }
            if (tokenType instanceof Assist && Assist.END == tokenType) {
                throw new SQLParsingException("Unsupported SQL statement: [%s]", this.sql);
            }
            lexer.nextToken();
        }
    }

    @ConstructorProperties(value={"sql"})
    public SQLJudgeEngine(String sql) {
        this.sql = sql;
    }
}

