/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.postgresql.PostgreSQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.LimitValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.select.AbstractSelectParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountToken;
import com.dangdang.ddframe.rdb.sharding.util.NumberUtil;
import com.google.common.base.Optional;

public class PostgreSQLSelectParser
extends AbstractSelectParser {
    public PostgreSQLSelectParser(SQLParser sqlParser) {
        super(sqlParser);
    }

    @Override
    public void query() {
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.SELECT)) {
            this.parseDistinct();
            this.parseSelectList();
            if (this.getSqlParser().skipIfEqual(DefaultKeyword.INTO)) {
                this.getSqlParser().skipIfEqual(PostgreSQLKeyword.TEMPORARY, PostgreSQLKeyword.TEMP, PostgreSQLKeyword.UNLOGGED);
                this.getSqlParser().skipIfEqual(DefaultKeyword.TABLE);
            }
        }
        this.parseFrom();
        this.parseWhere();
        this.parseGroupBy();
        if (this.getSqlParser().equalAny(PostgreSQLKeyword.WINDOW)) {
            throw new SQLParsingUnsupportedException(PostgreSQLKeyword.WINDOW);
        }
        this.parseOrderBy();
        this.parseLimit();
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.FETCH)) {
            throw new SQLParsingUnsupportedException(DefaultKeyword.FETCH);
        }
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.FOR)) {
            this.getSqlParser().skipIfEqual(DefaultKeyword.UPDATE, PostgreSQLKeyword.SHARE);
            if (this.getSqlParser().equalAny(PostgreSQLKeyword.OF)) {
                throw new SQLParsingUnsupportedException(PostgreSQLKeyword.OF);
            }
            this.getSqlParser().skipIfEqual(PostgreSQLKeyword.NOWAIT);
        }
        this.queryRest();
    }

    private void parseLimit() {
        Optional<LimitValue> offset = Optional.absent();
        Optional<LimitValue> rowCount = Optional.absent();
        while (true) {
            if (this.getSqlParser().skipIfEqual(PostgreSQLKeyword.LIMIT)) {
                rowCount = this.buildRowCount();
                continue;
            }
            if (!this.getSqlParser().skipIfEqual(PostgreSQLKeyword.OFFSET)) break;
            offset = this.buildOffset();
        }
        if (offset.isPresent() || rowCount.isPresent()) {
            this.setLimit(offset, rowCount);
        }
    }

    private Optional<LimitValue> buildRowCount() {
        int parameterIndex = this.getParametersIndex();
        int rowCountValue = -1;
        int rowCountIndex = -1;
        int valueBeginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
        if (this.getSqlParser().equalAny(DefaultKeyword.ALL)) {
            this.getSqlParser().getLexer().nextToken();
        } else {
            if (this.getSqlParser().equalAny(Literals.INT, Literals.FLOAT)) {
                rowCountValue = NumberUtil.roundHalfUp(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
                this.getSelectStatement().getSqlTokens().add(new RowCountToken(valueBeginPosition -= (rowCountValue + "").length(), rowCountValue));
            } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
                rowCountIndex = parameterIndex++;
                this.setParametersIndex(parameterIndex);
                rowCountValue = -1;
            } else {
                throw new SQLParsingException(this.getSqlParser().getLexer());
            }
            this.getSqlParser().getLexer().nextToken();
        }
        return Optional.of((Object)new LimitValue(rowCountValue, rowCountIndex));
    }

    private Optional<LimitValue> buildOffset() {
        int parameterIndex = this.getParametersIndex();
        int offsetValue = -1;
        int offsetIndex = -1;
        int offsetBeginPosition = this.getSqlParser().getLexer().getCurrentToken().getEndPosition();
        if (this.getSqlParser().equalAny(Literals.INT, Literals.FLOAT)) {
            offsetValue = NumberUtil.roundHalfUp(this.getSqlParser().getLexer().getCurrentToken().getLiterals());
            this.getSelectStatement().getSqlTokens().add(new OffsetToken(offsetBeginPosition -= (offsetValue + "").length(), offsetValue));
        } else if (this.getSqlParser().equalAny(Symbol.QUESTION)) {
            offsetIndex = parameterIndex++;
            this.setParametersIndex(parameterIndex);
        } else {
            throw new SQLParsingException(this.getSqlParser().getLexer());
        }
        this.getSqlParser().getLexer().nextToken();
        this.getSqlParser().skipIfEqual(PostgreSQLKeyword.ROW, PostgreSQLKeyword.ROWS);
        return Optional.of((Object)new LimitValue(offsetValue, offsetIndex));
    }

    private void setLimit(Optional<LimitValue> offset, Optional<LimitValue> rowCount) {
        Limit limit = new Limit(true);
        if (offset.isPresent()) {
            limit.setOffset((LimitValue)offset.get());
        }
        if (rowCount.isPresent()) {
            limit.setRowCount((LimitValue)rowCount.get());
        }
        this.getSelectStatement().setLimit(limit);
    }

    @Override
    protected boolean hasDistinctOn() {
        return true;
    }
}

