/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.routing.strategy;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.routing.strategy.MultipleKeysShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.routing.strategy.NoneKeyShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.routing.strategy.ShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.routing.strategy.SingleKeyShardingAlgorithm;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class ShardingStrategy {
    private final Collection<String> shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final ShardingAlgorithm shardingAlgorithm;

    public ShardingStrategy(String shardingColumn, ShardingAlgorithm shardingAlgorithm) {
        this(Collections.singletonList(shardingColumn), shardingAlgorithm);
    }

    public ShardingStrategy(Collection<String> shardingColumns, ShardingAlgorithm shardingAlgorithm) {
        this.shardingColumns.addAll(shardingColumns);
        this.shardingAlgorithm = shardingAlgorithm;
    }

    public Collection<String> doStaticSharding(SQLType sqlType, Collection<String> availableTargetNames, Collection<ShardingValue<?>> shardingValues) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (shardingValues.isEmpty()) {
            Preconditions.checkState((!this.isInsertMultiple(sqlType, availableTargetNames) ? 1 : 0) != 0, (Object)"INSERT statement should contain sharding value.");
            result.addAll(availableTargetNames);
        } else {
            result.addAll(this.doSharding(shardingValues, availableTargetNames));
        }
        return result;
    }

    public Collection<String> doDynamicSharding(Collection<ShardingValue<?>> shardingValues) {
        Preconditions.checkState((!shardingValues.isEmpty() ? 1 : 0) != 0, (Object)"Dynamic table should contain sharding value.");
        List<String> availableTargetNames = Collections.emptyList();
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(this.doSharding(shardingValues, availableTargetNames));
        return result;
    }

    private Collection<String> doSharding(Collection<ShardingValue<?>> shardingValues, Collection<String> availableTargetNames) {
        if (this.shardingAlgorithm instanceof NoneKeyShardingAlgorithm) {
            return Collections.singletonList(((NoneKeyShardingAlgorithm)this.shardingAlgorithm).doSharding(availableTargetNames, shardingValues.iterator().next()));
        }
        if (this.shardingAlgorithm instanceof SingleKeyShardingAlgorithm) {
            SingleKeyShardingAlgorithm singleKeyShardingAlgorithm = (SingleKeyShardingAlgorithm)this.shardingAlgorithm;
            ShardingValue<?> shardingValue = shardingValues.iterator().next();
            switch (shardingValue.getType()) {
                case SINGLE: {
                    return Collections.singletonList(singleKeyShardingAlgorithm.doEqualSharding(availableTargetNames, shardingValue));
                }
                case LIST: {
                    return singleKeyShardingAlgorithm.doInSharding(availableTargetNames, shardingValue);
                }
                case RANGE: {
                    return singleKeyShardingAlgorithm.doBetweenSharding(availableTargetNames, shardingValue);
                }
            }
            throw new UnsupportedOperationException(((Object)((Object)shardingValue.getType())).getClass().getName());
        }
        if (this.shardingAlgorithm instanceof MultipleKeysShardingAlgorithm) {
            return ((MultipleKeysShardingAlgorithm)this.shardingAlgorithm).doSharding(availableTargetNames, shardingValues);
        }
        throw new UnsupportedOperationException(this.shardingAlgorithm.getClass().getName());
    }

    private boolean isInsertMultiple(SQLType sqlType, Collection<String> availableTargetNames) {
        return SQLType.INSERT == sqlType && availableTargetNames.size() > 1;
    }

    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }
}

