/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.routing.type.simple;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataNode;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.TableShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.hint.ShardingKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatement;
import com.dangdang.ddframe.rdb.sharding.routing.type.RoutingEngine;
import com.dangdang.ddframe.rdb.sharding.routing.type.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.routing.type.TableUnit;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SimpleRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final List<Object> parameters;
    private final String logicTableName;
    private final SQLStatement sqlStatement;

    @Override
    public RoutingResult route() {
        TableRule tableRule = this.shardingRule.getTableRule(this.logicTableName);
        Collection<String> routedDataSources = this.routeDataSources(tableRule);
        Collection<String> routedTables = this.routeTables(tableRule, routedDataSources);
        return this.generateRoutingResult(tableRule, routedDataSources, routedTables);
    }

    private Collection<String> routeDataSources(TableRule tableRule) {
        DatabaseShardingStrategy strategy = this.shardingRule.getDatabaseShardingStrategy(tableRule);
        List<ShardingValue<?>> shardingValues = HintManagerHolder.isUseShardingHint() ? this.getDatabaseShardingValuesFromHint(strategy.getShardingColumns()) : this.getShardingValues(strategy.getShardingColumns());
        Collection<String> result = strategy.doStaticSharding(this.sqlStatement.getType(), tableRule.getActualDatasourceNames(), shardingValues);
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        return result;
    }

    private Collection<String> routeTables(TableRule tableRule, Collection<String> routedDataSources) {
        TableShardingStrategy strategy = this.shardingRule.getTableShardingStrategy(tableRule);
        List<ShardingValue<?>> shardingValues = HintManagerHolder.isUseShardingHint() ? this.getTableShardingValuesFromHint(strategy.getShardingColumns()) : this.getShardingValues(strategy.getShardingColumns());
        Collection<String> result = tableRule.isDynamic() ? strategy.doDynamicSharding(shardingValues) : strategy.doStaticSharding(this.sqlStatement.getType(), tableRule.getActualTableNames(routedDataSources), shardingValues);
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no table route info");
        return result;
    }

    private List<ShardingValue<?>> getDatabaseShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList result = new ArrayList(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue<?>> shardingValue = HintManagerHolder.getDatabaseShardingValue(new ShardingKey(this.logicTableName, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue<?>)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue<?>> getTableShardingValuesFromHint(Collection<String> shardingColumns) {
        ArrayList result = new ArrayList(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<ShardingValue<?>> shardingValue = HintManagerHolder.getTableShardingValue(new ShardingKey(this.logicTableName, each));
            if (!shardingValue.isPresent()) continue;
            result.add((ShardingValue<?>)shardingValue.get());
        }
        return result;
    }

    private List<ShardingValue<?>> getShardingValues(Collection<String> shardingColumns) {
        ArrayList result = new ArrayList(shardingColumns.size());
        for (String each : shardingColumns) {
            Optional<Condition> condition = this.sqlStatement.getConditions().find(new Column(each, this.logicTableName));
            if (!condition.isPresent()) continue;
            result.add(((Condition)condition.get()).getShardingValue(this.parameters));
        }
        return result;
    }

    private RoutingResult generateRoutingResult(TableRule tableRule, Collection<String> routedDataSources, Collection<String> routedTables) {
        RoutingResult result = new RoutingResult();
        for (DataNode each : tableRule.getActualDataNodes(routedDataSources, routedTables)) {
            result.getTableUnits().getTableUnits().add(new TableUnit(each.getDataSourceName(), this.logicTableName, each.getTableName()));
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "parameters", "logicTableName", "sqlStatement"})
    public SimpleRoutingEngine(ShardingRule shardingRule, List<Object> parameters, String logicTableName, SQLStatement sqlStatement) {
        this.shardingRule = shardingRule;
        this.parameters = parameters;
        this.logicTableName = logicTableName;
        this.sqlStatement = sqlStatement;
    }
}

