/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.util;

import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberUtil {
    public static int roundHalfUp(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Double) {
            return new BigDecimal((Double)obj).setScale(0, 4).intValue();
        }
        if (obj instanceof Float) {
            return new BigDecimal(((Float)obj).floatValue()).setScale(0, 4).intValue();
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj).setScale(0, 4).intValue();
        }
        throw new ShardingJdbcException("Invalid value to transfer: %s", obj);
    }

    public static Number getExactlyNumber(String value, int radix) {
        BigInteger result = new BigInteger(value, radix);
        if (result.compareTo(new BigInteger(String.valueOf(Integer.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Integer.MAX_VALUE))) <= 0) {
            return result.intValue();
        }
        if (result.compareTo(new BigInteger(String.valueOf(Long.MIN_VALUE))) >= 0 && result.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) <= 0) {
            return result.longValue();
        }
        return result;
    }

    private NumberUtil() {
    }
}

