/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.adapter;

import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.invocation.SetParameterMethodInvocation;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.unsupported.AbstractUnsupportedOperationPreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractPreparedStatementAdapter
extends AbstractUnsupportedOperationPreparedStatement {
    private final List<SetParameterMethodInvocation> setParameterMethodInvocations = new LinkedList<SetParameterMethodInvocation>();
    private final List<Object> parameters = new ArrayList<Object>();

    protected AbstractPreparedStatementAdapter(ShardingConnection shardingConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(shardingConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, null);
        this.recordSetParameterForNull(new Class[]{Integer.TYPE, Integer.TYPE}, parameterIndex, sqlType);
    }

    @Override
    public final void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, null);
        this.recordSetParameterForNull(new Class[]{Integer.TYPE, Integer.TYPE, String.class}, parameterIndex, sqlType, typeName);
    }

    @Override
    public final void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBoolean", new Class[]{Integer.TYPE, Boolean.TYPE}, parameterIndex, x);
    }

    @Override
    public final void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setByte", new Class[]{Integer.TYPE, Byte.TYPE}, parameterIndex, x);
    }

    @Override
    public final void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setShort", new Class[]{Integer.TYPE, Short.TYPE}, parameterIndex, x);
    }

    @Override
    public final void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setInt", new Class[]{Integer.TYPE, Integer.TYPE}, parameterIndex, x);
    }

    @Override
    public final void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setLong", new Class[]{Integer.TYPE, Long.TYPE}, parameterIndex, x);
    }

    @Override
    public final void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, Float.valueOf(x));
        this.recordSetParameter("setFloat", new Class[]{Integer.TYPE, Float.TYPE}, parameterIndex, Float.valueOf(x));
    }

    @Override
    public final void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setDouble", new Class[]{Integer.TYPE, Double.TYPE}, parameterIndex, x);
    }

    @Override
    public final void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setString", new Class[]{Integer.TYPE, String.class}, parameterIndex, x);
    }

    @Override
    public final void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBigDecimal", new Class[]{Integer.TYPE, BigDecimal.class}, parameterIndex, x);
    }

    @Override
    public final void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setDate", new Class[]{Integer.TYPE, Date.class}, parameterIndex, x);
    }

    @Override
    public final void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setDate", new Class[]{Integer.TYPE, Date.class, Calendar.class}, parameterIndex, x, cal);
    }

    @Override
    public final void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setTime", new Class[]{Integer.TYPE, Time.class}, parameterIndex, x);
    }

    @Override
    public final void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setTime", new Class[]{Integer.TYPE, Time.class, Calendar.class}, parameterIndex, x, cal);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class}, parameterIndex, x);
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setTimestamp", new Class[]{Integer.TYPE, Timestamp.class, Calendar.class}, parameterIndex, x, cal);
    }

    @Override
    public final void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBytes", new Class[]{Integer.TYPE, byte[].class}, parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBlob", new Class[]{Integer.TYPE, Blob.class}, parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBlob", new Class[]{Integer.TYPE, InputStream.class}, parameterIndex, x);
    }

    @Override
    public final void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBlob", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setClob", new Class[]{Integer.TYPE, Clob.class}, parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setClob", new Class[]{Integer.TYPE, Reader.class}, parameterIndex, x);
    }

    @Override
    public final void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class}, parameterIndex, x);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setUnicodeStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class}, parameterIndex, x);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setCharacterStream", new Class[]{Integer.TYPE, Reader.class}, parameterIndex, x);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Integer.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, parameterIndex, x, length);
    }

    @Override
    public final void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setURL", new Class[]{Integer.TYPE, URL.class}, parameterIndex, x);
    }

    @Override
    public final void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}, parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setObject", new Class[]{Integer.TYPE, Object.class}, parameterIndex, x);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE}, parameterIndex, x, targetSqlType);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.recordSetParameter("setObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE}, parameterIndex, x, targetSqlType, scaleOrLength);
    }

    private void setParameter(int parameterIndex, Object value) {
        if (this.parameters.size() == parameterIndex - 1) {
            this.parameters.add(value);
            return;
        }
        for (int i = this.parameters.size(); i <= parameterIndex - 1; ++i) {
            this.parameters.add(null);
        }
        this.parameters.set(parameterIndex - 1, value);
    }

    private void recordSetParameter(String methodName, Class[] argumentTypes, Object ... arguments) {
        try {
            this.setParameterMethodInvocations.add(new SetParameterMethodInvocation(PreparedStatement.class.getMethod(methodName, argumentTypes), arguments, arguments[1]));
        }
        catch (NoSuchMethodException ex) {
            throw new ShardingJdbcException(ex);
        }
    }

    private void recordSetParameterForNull(Class[] argumentTypes, Object ... arguments) {
        try {
            this.setParameterMethodInvocations.add(new SetParameterMethodInvocation(PreparedStatement.class.getMethod("setNull", argumentTypes), arguments, null));
        }
        catch (NoSuchMethodException ex) {
            throw new ShardingJdbcException(ex);
        }
    }

    protected void replaySetParameter(PreparedStatement preparedStatement) {
        this.addParameters();
        for (SetParameterMethodInvocation each : this.setParameterMethodInvocations) {
            this.updateParameterValues(each, this.parameters.get(each.getIndex() - 1));
            each.invoke(preparedStatement);
        }
    }

    private void addParameters() {
        for (int i = this.setParameterMethodInvocations.size(); i < this.parameters.size(); ++i) {
            this.recordSetParameter("setObject", new Class[]{Integer.TYPE, Object.class}, i + 1, this.parameters.get(i));
        }
    }

    private void updateParameterValues(SetParameterMethodInvocation setParameterMethodInvocation, Object value) {
        if (!Objects.equals(setParameterMethodInvocation.getValue(), value)) {
            setParameterMethodInvocation.changeValueArgument(value);
        }
    }

    @Override
    public final void clearParameters() throws SQLException {
        this.parameters.clear();
        this.setParameterMethodInvocations.clear();
    }

    public List<Object> getParameters() {
        return this.parameters;
    }
}

