/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset;

import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractResultSetAdapter;
import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.util.ResultSetUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public final class ShardingResultSet
extends AbstractResultSetAdapter {
    private final ResultSetMerger mergeResultSet;
    private boolean wasNull;

    public ShardingResultSet(List<ResultSet> resultSets, ResultSetMerger mergeResultSet) {
        super(resultSets);
        this.mergeResultSet = mergeResultSet;
    }

    @Override
    public boolean next() throws SQLException {
        return this.mergeResultSet.next();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Boolean.TYPE);
        this.wasNull = false;
        return (Boolean)ResultSetUtil.convertValue(result, Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Boolean.TYPE);
        this.wasNull = false;
        return (Boolean)ResultSetUtil.convertValue(result, Boolean.TYPE);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Byte.TYPE);
        this.wasNull = null == result;
        return (Byte)ResultSetUtil.convertValue(result, Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Byte.TYPE);
        this.wasNull = null == result;
        return (Byte)ResultSetUtil.convertValue(result, Byte.TYPE);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Short.TYPE);
        this.wasNull = null == result;
        return (Short)ResultSetUtil.convertValue(result, Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Short.TYPE);
        this.wasNull = null == result;
        return (Short)ResultSetUtil.convertValue(result, Short.TYPE);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Integer.TYPE);
        this.wasNull = null == result;
        return (Integer)ResultSetUtil.convertValue(result, Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Integer.TYPE);
        this.wasNull = null == result;
        return (Integer)ResultSetUtil.convertValue(result, Integer.TYPE);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Long.TYPE);
        this.wasNull = null == result;
        return (Long)ResultSetUtil.convertValue(result, Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Long.TYPE);
        this.wasNull = null == result;
        return (Long)ResultSetUtil.convertValue(result, Long.TYPE);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Float.TYPE);
        this.wasNull = null == result;
        return ((Float)ResultSetUtil.convertValue(result, Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Float.TYPE);
        this.wasNull = null == result;
        return ((Float)ResultSetUtil.convertValue(result, Float.TYPE)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Double.TYPE);
        this.wasNull = null == result;
        return (Double)ResultSetUtil.convertValue(result, Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Double.TYPE);
        this.wasNull = null == result;
        return (Double)ResultSetUtil.convertValue(result, Double.TYPE);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, String.class);
        this.wasNull = null == result;
        return (String)ResultSetUtil.convertValue(result, String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, String.class);
        this.wasNull = null == result;
        return (String)ResultSetUtil.convertValue(result, String.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, BigDecimal.class);
        this.wasNull = null == result;
        return (BigDecimal)ResultSetUtil.convertValue(result, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, BigDecimal.class);
        this.wasNull = null == result;
        return (BigDecimal)ResultSetUtil.convertValue(result, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, BigDecimal.class);
        this.wasNull = null == result;
        return (BigDecimal)ResultSetUtil.convertValue(result, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, BigDecimal.class);
        this.wasNull = null == result;
        return (BigDecimal)ResultSetUtil.convertValue(result, BigDecimal.class);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, byte[].class);
        this.wasNull = null == result;
        return (byte[])ResultSetUtil.convertValue(result, byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, byte[].class);
        this.wasNull = null == result;
        return (byte[])ResultSetUtil.convertValue(result, byte[].class);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Date.class);
        this.wasNull = null == result;
        return (Date)ResultSetUtil.convertValue(result, Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Date.class);
        this.wasNull = null == result;
        return (Date)ResultSetUtil.convertValue(result, Date.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Object result = this.mergeResultSet.getCalendarValue(columnIndex, Date.class, cal);
        this.wasNull = null == result;
        return (Date)ResultSetUtil.convertValue(result, Date.class);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        Object result = this.mergeResultSet.getCalendarValue(columnLabel, Date.class, cal);
        this.wasNull = null == result;
        return (Date)ResultSetUtil.convertValue(result, Date.class);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Time.class);
        this.wasNull = null == result;
        return (Time)ResultSetUtil.convertValue(result, Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Time.class);
        this.wasNull = null == result;
        return (Time)ResultSetUtil.convertValue(result, Time.class);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Object result = this.mergeResultSet.getCalendarValue(columnIndex, Time.class, cal);
        this.wasNull = null == result;
        return (Time)ResultSetUtil.convertValue(result, Time.class);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        Object result = this.mergeResultSet.getCalendarValue(columnLabel, Time.class, cal);
        this.wasNull = null == result;
        return (Time)ResultSetUtil.convertValue(result, Time.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Timestamp.class);
        this.wasNull = null == result;
        return (Timestamp)ResultSetUtil.convertValue(result, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Timestamp.class);
        this.wasNull = null == result;
        return (Timestamp)ResultSetUtil.convertValue(result, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Object result = this.mergeResultSet.getCalendarValue(columnIndex, Timestamp.class, cal);
        this.wasNull = null == result;
        return (Timestamp)ResultSetUtil.convertValue(result, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        Object result = this.mergeResultSet.getCalendarValue(columnLabel, Timestamp.class, cal);
        this.wasNull = null == result;
        return (Timestamp)ResultSetUtil.convertValue(result, Timestamp.class);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        InputStream result = this.mergeResultSet.getInputStream(columnIndex, "Ascii");
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        InputStream result = this.mergeResultSet.getInputStream(columnLabel, "Ascii");
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        InputStream result = this.mergeResultSet.getInputStream(columnIndex, "Unicode");
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        InputStream result = this.mergeResultSet.getInputStream(columnLabel, "Unicode");
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        InputStream result = this.mergeResultSet.getInputStream(columnIndex, "Binary");
        this.wasNull = null == result;
        return result;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        InputStream result = this.mergeResultSet.getInputStream(columnLabel, "Binary");
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Reader.class);
        this.wasNull = null == result;
        return (Reader)result;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Reader.class);
        this.wasNull = null == result;
        return (Reader)result;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Blob.class);
        this.wasNull = null == result;
        return (Blob)result;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Blob.class);
        this.wasNull = null == result;
        return (Blob)result;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Clob.class);
        this.wasNull = null == result;
        return (Clob)result;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Clob.class);
        this.wasNull = null == result;
        return (Clob)result;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, URL.class);
        this.wasNull = null == result;
        return (URL)result;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, URL.class);
        this.wasNull = null == result;
        return (URL)result;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, SQLXML.class);
        this.wasNull = null == result;
        return (SQLXML)result;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, SQLXML.class);
        this.wasNull = null == result;
        return (SQLXML)result;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnIndex, Object.class);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        Object result = this.mergeResultSet.getValue(columnLabel, Object.class);
        this.wasNull = null == result;
        return result;
    }
}

