/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.groupby;

import com.dangdang.ddframe.rdb.sharding.constant.OrderType;
import com.dangdang.ddframe.rdb.sharding.merger.common.AbstractMemoryResultSetMerger;
import com.dangdang.ddframe.rdb.sharding.merger.common.MemoryResultSetRow;
import com.dangdang.ddframe.rdb.sharding.merger.groupby.GroupByRowComparator;
import com.dangdang.ddframe.rdb.sharding.merger.groupby.GroupByValue;
import com.dangdang.ddframe.rdb.sharding.merger.groupby.aggregation.AggregationUnit;
import com.dangdang.ddframe.rdb.sharding.merger.groupby.aggregation.AggregationUnitFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.selectitem.AggregationSelectItem;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dql.select.SelectStatement;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class GroupByMemoryResultSetMerger
extends AbstractMemoryResultSetMerger {
    private final SelectStatement selectStatement;
    private final OrderType nullOrderType;
    private final Iterator<MemoryResultSetRow> memoryResultSetRows;

    public GroupByMemoryResultSetMerger(Map<String, Integer> labelAndIndexMap, List<ResultSet> resultSets, SelectStatement selectStatement, OrderType nullOrderType) throws SQLException {
        super(labelAndIndexMap);
        this.selectStatement = selectStatement;
        this.nullOrderType = nullOrderType;
        this.memoryResultSetRows = this.init(resultSets);
    }

    private Iterator<MemoryResultSetRow> init(List<ResultSet> resultSets) throws SQLException {
        HashMap<GroupByValue, MemoryResultSetRow> dataMap = new HashMap<GroupByValue, MemoryResultSetRow>(1024);
        HashMap<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap = new HashMap<GroupByValue, Map<AggregationSelectItem, AggregationUnit>>(1024);
        for (ResultSet each : resultSets) {
            while (each.next()) {
                GroupByValue groupByValue = new GroupByValue(each, this.selectStatement.getGroupByItems());
                this.initForFirstGroupByValue(each, groupByValue, dataMap, aggregationMap);
                this.aggregate(each, groupByValue, aggregationMap);
            }
        }
        this.setAggregationValueToMemoryRow(dataMap, aggregationMap);
        List<MemoryResultSetRow> result = this.getMemoryResultSetRows(dataMap);
        if (!result.isEmpty()) {
            this.setCurrentResultSetRow(result.get(0));
        }
        return result.iterator();
    }

    private void initForFirstGroupByValue(ResultSet resultSet, GroupByValue groupByValue, Map<GroupByValue, MemoryResultSetRow> dataMap, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) throws SQLException {
        if (!dataMap.containsKey(groupByValue)) {
            dataMap.put(groupByValue, new MemoryResultSetRow(resultSet));
        }
        if (!aggregationMap.containsKey(groupByValue)) {
            ImmutableMap map = Maps.toMap(this.selectStatement.getAggregationSelectItems(), (Function)new Function<AggregationSelectItem, AggregationUnit>(){

                public AggregationUnit apply(AggregationSelectItem input) {
                    return AggregationUnitFactory.create(input.getType());
                }
            });
            aggregationMap.put(groupByValue, (Map<AggregationSelectItem, AggregationUnit>)map);
        }
    }

    private void aggregate(ResultSet resultSet, GroupByValue groupByValue, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) throws SQLException {
        for (AggregationSelectItem each : this.selectStatement.getAggregationSelectItems()) {
            ArrayList values = new ArrayList(2);
            if (each.getDerivedAggregationSelectItems().isEmpty()) {
                values.add(this.getAggregationValue(resultSet, each));
            } else {
                for (AggregationSelectItem derived : each.getDerivedAggregationSelectItems()) {
                    values.add(this.getAggregationValue(resultSet, derived));
                }
            }
            aggregationMap.get(groupByValue).get(each).merge(values);
        }
    }

    private Comparable<?> getAggregationValue(ResultSet resultSet, AggregationSelectItem aggregationSelectItem) throws SQLException {
        Object result = resultSet.getObject(aggregationSelectItem.getIndex());
        Preconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, (Object)"Aggregation value must implements Comparable");
        return (Comparable)result;
    }

    private void setAggregationValueToMemoryRow(Map<GroupByValue, MemoryResultSetRow> dataMap, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) {
        for (Map.Entry<GroupByValue, MemoryResultSetRow> entry : dataMap.entrySet()) {
            for (AggregationSelectItem each : this.selectStatement.getAggregationSelectItems()) {
                entry.getValue().setCell(each.getIndex(), aggregationMap.get(entry.getKey()).get(each).getResult());
            }
        }
    }

    private List<MemoryResultSetRow> getMemoryResultSetRows(Map<GroupByValue, MemoryResultSetRow> dataMap) {
        ArrayList<MemoryResultSetRow> result = new ArrayList<MemoryResultSetRow>(dataMap.values());
        Collections.sort(result, new GroupByRowComparator(this.selectStatement, this.nullOrderType));
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.memoryResultSetRows.hasNext()) {
            this.setCurrentResultSetRow(this.memoryResultSetRows.next());
            return true;
        }
        return false;
    }
}

