/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.oracle.OracleKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.AbstractSQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingUnsupportedException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dql.select.AbstractSelectParser;
import java.util.Collection;
import java.util.Collections;

public final class OracleSelectParser
extends AbstractSelectParser {
    public OracleSelectParser(AbstractSQLParser sqlParser) {
        super(sqlParser);
    }

    @Override
    protected Collection<Keyword> getCustomizedDistinctKeywords() {
        return Collections.singletonList(DefaultKeyword.UNIQUE);
    }

    @Override
    protected void customizedBetweenWhereAndGroupBy() {
        this.skipHierarchicalQueryClause();
    }

    private void skipHierarchicalQueryClause() {
        this.skipConnect();
        this.skipStart();
        this.skipConnect();
    }

    private void skipStart() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.START)) {
            this.getSqlParser().accept(DefaultKeyword.WITH);
            this.getSqlParser().parseComparisonCondition(this.getSelectStatement());
        }
    }

    private void skipConnect() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.CONNECT)) {
            this.getSqlParser().accept(DefaultKeyword.BY);
            this.getSqlParser().skipIfEqual(OracleKeyword.PRIOR);
            if (this.getSqlParser().skipIfEqual(OracleKeyword.NOCYCLE)) {
                this.getSqlParser().skipIfEqual(OracleKeyword.PRIOR);
            }
            this.getSqlParser().parseComparisonCondition(this.getSelectStatement());
        }
    }

    @Override
    protected void customizedBetweenGroupByAndOrderBy() {
        this.skipModelClause();
    }

    private void skipModelClause() {
        if (!this.getSqlParser().skipIfEqual(OracleKeyword.MODEL)) {
            return;
        }
        this.skipCellReferenceOptions();
        this.getSqlParser().skipIfEqual(OracleKeyword.RETURN);
        this.getSqlParser().skipIfEqual(DefaultKeyword.ALL);
        this.getSqlParser().skipIfEqual(OracleKeyword.UPDATED);
        this.getSqlParser().skipIfEqual(OracleKeyword.ROWS);
        while (this.getSqlParser().skipIfEqual(OracleKeyword.REFERENCE)) {
            this.getSqlParser().getLexer().nextToken();
            this.getSqlParser().accept(DefaultKeyword.ON);
            this.getSqlParser().skipParentheses();
            this.skipModelColumnClause();
            this.skipCellReferenceOptions();
        }
        this.skipMainModelClause();
    }

    private void skipCellReferenceOptions() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.IGNORE)) {
            this.getSqlParser().accept(OracleKeyword.NAV);
        } else if (this.getSqlParser().skipIfEqual(OracleKeyword.KEEP)) {
            this.getSqlParser().accept(OracleKeyword.NAV);
        }
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.UNIQUE)) {
            this.getSqlParser().skipIfEqual(OracleKeyword.DIMENSION, OracleKeyword.SINGLE);
            this.getSqlParser().skipIfEqual(OracleKeyword.REFERENCE);
        }
    }

    private void skipMainModelClause() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.MAIN)) {
            this.getSqlParser().getLexer().nextToken();
        }
        this.skipQueryPartitionClause();
        this.getSqlParser().accept(OracleKeyword.DIMENSION);
        this.getSqlParser().accept(DefaultKeyword.BY);
        this.getSqlParser().skipParentheses();
        this.getSqlParser().accept(OracleKeyword.MEASURES);
        this.getSqlParser().skipParentheses();
        this.skipCellReferenceOptions();
        this.skipModelRulesClause();
    }

    private void skipModelRulesClause() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.RULES)) {
            this.getSqlParser().skipIfEqual(DefaultKeyword.UPDATE);
            this.getSqlParser().skipIfEqual(OracleKeyword.UPSERT);
            if (this.getSqlParser().skipIfEqual(OracleKeyword.AUTOMATIC)) {
                this.getSqlParser().accept(DefaultKeyword.ORDER);
            } else if (this.getSqlParser().skipIfEqual(OracleKeyword.SEQUENTIAL)) {
                this.getSqlParser().accept(DefaultKeyword.ORDER);
            }
        }
        if (this.getSqlParser().skipIfEqual(DefaultKeyword.ITERATE)) {
            this.getSqlParser().skipParentheses();
            if (this.getSqlParser().skipIfEqual(DefaultKeyword.UNTIL)) {
                this.getSqlParser().skipParentheses();
            }
        }
        this.getSqlParser().skipParentheses();
    }

    private void skipQueryPartitionClause() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.PARTITION)) {
            this.getSqlParser().accept(DefaultKeyword.BY);
            if (this.getSqlParser().equalAny(Symbol.LEFT_PAREN)) {
                this.getSqlParser().skipParentheses();
            } else {
                throw new UnsupportedOperationException("Cannot support PARTITION BY without ()");
            }
        }
    }

    private void skipModelColumnClause() {
        throw new SQLParsingUnsupportedException(this.getSqlParser().getLexer().getCurrentToken().getType());
    }

    @Override
    protected void customizedSelect() {
        if (this.getSqlParser().equalAny(DefaultKeyword.FOR)) {
            this.skipForUpdate();
        }
        if (this.getSelectStatement().getOrderByItems().isEmpty()) {
            this.parseOrderBy();
        }
    }

    @Override
    protected void parseGroupBy() {
        if (this.getSqlParser().equalAny(DefaultKeyword.GROUP)) {
            this.getSqlParser().getLexer().nextToken();
            this.getSqlParser().accept(DefaultKeyword.BY);
            while (true) {
                if (this.getSqlParser().equalAny(OracleKeyword.ROLLUP, OracleKeyword.CUBE, OracleKeyword.GROUPING)) {
                    throw new UnsupportedOperationException("Cannot support ROLLUP, CUBE, GROUPING SETS");
                }
                this.addGroupByItem(this.getSqlParser().parseExpression());
                if (!this.getSqlParser().equalAny(Symbol.COMMA)) break;
                this.getSqlParser().getLexer().nextToken();
            }
            if (this.getSqlParser().skipIfEqual(DefaultKeyword.HAVING)) {
                throw new UnsupportedOperationException("Cannot support Having");
            }
            this.getSelectStatement().setGroupByLastPosition(this.getSqlParser().getLexer().getCurrentToken().getEndPosition() - this.getSqlParser().getLexer().getCurrentToken().getLiterals().length());
        }
    }

    @Override
    protected void customizedParseTableFactor() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.ONLY)) {
            this.getSqlParser().skipIfEqual(Symbol.LEFT_PAREN);
            this.parseQueryTableExpression();
            this.getSqlParser().skipIfEqual(Symbol.RIGHT_PAREN);
            this.skipFlashbackQueryClause();
        } else {
            this.parseQueryTableExpression();
            this.skipPivotClause();
            this.skipFlashbackQueryClause();
        }
    }

    private void parseQueryTableExpression() {
        this.parseTableFactor();
        this.parseSample();
        this.skipPartition();
    }

    private void parseSample() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.SAMPLE)) {
            this.getSqlParser().skipIfEqual(OracleKeyword.BLOCK);
            this.getSqlParser().skipParentheses();
            if (this.getSqlParser().skipIfEqual(OracleKeyword.SEED)) {
                this.getSqlParser().skipParentheses();
            }
        }
    }

    private void skipPartition() {
        this.skipPartition(OracleKeyword.PARTITION);
        this.skipPartition(OracleKeyword.SUBPARTITION);
    }

    private void skipPartition(OracleKeyword keyword) {
        if (this.getSqlParser().skipIfEqual(keyword)) {
            this.getSqlParser().skipParentheses();
            if (this.getSqlParser().skipIfEqual(DefaultKeyword.FOR)) {
                this.getSqlParser().skipParentheses();
            }
        }
    }

    private void skipPivotClause() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.PIVOT)) {
            this.getSqlParser().skipIfEqual(OracleKeyword.XML);
            this.getSqlParser().skipParentheses();
        } else if (this.getSqlParser().skipIfEqual(OracleKeyword.UNPIVOT)) {
            if (this.getSqlParser().skipIfEqual(OracleKeyword.INCLUDE)) {
                this.getSqlParser().accept(OracleKeyword.NULLS);
            } else if (this.getSqlParser().skipIfEqual(OracleKeyword.EXCLUDE)) {
                this.getSqlParser().accept(OracleKeyword.NULLS);
            }
            this.getSqlParser().skipParentheses();
        }
    }

    private void skipFlashbackQueryClause() {
        if (this.isFlashbackQueryClauseForVersions() || this.isFlashbackQueryClauseForAs()) {
            throw new UnsupportedOperationException("Cannot support Flashback Query");
        }
    }

    private boolean isFlashbackQueryClauseForVersions() {
        return this.getSqlParser().skipIfEqual(OracleKeyword.VERSIONS) && this.getSqlParser().skipIfEqual(DefaultKeyword.BETWEEN);
    }

    private boolean isFlashbackQueryClauseForAs() {
        return this.getSqlParser().skipIfEqual(DefaultKeyword.AS) && this.getSqlParser().skipIfEqual(OracleKeyword.OF) && (this.getSqlParser().skipIfEqual(OracleKeyword.SCN) || this.getSqlParser().skipIfEqual(OracleKeyword.TIMESTAMP));
    }

    private void skipForUpdate() {
        this.getSqlParser().getLexer().nextToken();
        this.getSqlParser().accept(DefaultKeyword.UPDATE);
        if (this.getSqlParser().skipIfEqual(OracleKeyword.OF)) {
            do {
                this.getSqlParser().parseExpression();
            } while (this.getSqlParser().skipIfEqual(Symbol.COMMA));
        }
        if (this.getSqlParser().equalAny(OracleKeyword.NOWAIT, OracleKeyword.WAIT)) {
            this.getSqlParser().getLexer().nextToken();
        } else if (this.getSqlParser().skipIfEqual(OracleKeyword.SKIP)) {
            this.getSqlParser().accept(OracleKeyword.LOCKED);
        }
    }

    @Override
    protected void skipAfterOrderByItem() {
        if (this.getSqlParser().skipIfEqual(OracleKeyword.NULLS)) {
            this.getSqlParser().getLexer().nextToken();
            if (!this.getSqlParser().skipIfEqual(OracleKeyword.FIRST, OracleKeyword.LAST)) {
                throw new SQLParsingUnsupportedException(this.getSqlParser().getLexer().getCurrentToken().getType());
            }
        }
    }
}

