/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dml.update;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.AbstractSQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.SQLStatementParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.statement.dml.DMLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.TableToken;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;

public abstract class AbstractUpdateParser
implements SQLStatementParser {
    private final AbstractSQLParser sqlParser;
    private final DMLStatement updateStatement;
    private int parametersIndex;

    public AbstractUpdateParser(AbstractSQLParser sqlParser) {
        this.sqlParser = sqlParser;
        this.updateStatement = new DMLStatement();
    }

    @Override
    public DMLStatement parse() {
        this.sqlParser.getLexer().nextToken();
        this.skipBetweenUpdateAndTable();
        this.sqlParser.parseSingleTable(this.updateStatement);
        this.parseSetItems();
        this.sqlParser.skipUntil(DefaultKeyword.WHERE);
        this.sqlParser.setParametersIndex(this.parametersIndex);
        this.sqlParser.parseWhere(this.updateStatement);
        return this.updateStatement;
    }

    protected abstract void skipBetweenUpdateAndTable();

    private void parseSetItems() {
        this.sqlParser.accept(DefaultKeyword.SET);
        do {
            this.parseSetItem();
        } while (this.sqlParser.skipIfEqual(Symbol.COMMA));
    }

    private void parseSetItem() {
        this.parseSetColumn();
        this.sqlParser.skipIfEqual(Symbol.EQ, Symbol.COLON_EQ);
        this.parseSetValue();
    }

    private void parseSetColumn() {
        if (this.sqlParser.equalAny(Symbol.LEFT_PAREN)) {
            this.sqlParser.skipParentheses();
            return;
        }
        int beginPosition = this.sqlParser.getLexer().getCurrentToken().getEndPosition();
        String literals = this.sqlParser.getLexer().getCurrentToken().getLiterals();
        this.sqlParser.getLexer().nextToken();
        if (this.sqlParser.skipIfEqual(Symbol.DOT)) {
            if (this.updateStatement.getTables().getSingleTableName().equalsIgnoreCase(SQLUtil.getExactlyValue(literals))) {
                this.updateStatement.getSqlTokens().add(new TableToken(beginPosition - literals.length(), literals));
            }
            this.sqlParser.getLexer().nextToken();
        }
    }

    private void parseSetValue() {
        this.sqlParser.parseExpression(this.updateStatement);
        this.parametersIndex = this.sqlParser.getParametersIndex();
    }

    protected AbstractSQLParser getSqlParser() {
        return this.sqlParser;
    }

    protected DMLStatement getUpdateStatement() {
        return this.updateStatement;
    }
}

