/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource;

import com.dangdang.ddframe.rdb.sharding.api.strategy.slave.MasterSlaveLoadBalanceStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.slave.MasterSlaveLoadBalanceStrategyType;
import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractDataSourceAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.MasterSlaveConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource.NamedDataSource;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public final class MasterSlaveDataSource
extends AbstractDataSourceAdapter {
    private static final ThreadLocal<Boolean> DML_FLAG = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final String name;
    private final String masterDataSourceName;
    private final DataSource masterDataSource;
    private final Map<String, DataSource> slaveDataSources;
    private final MasterSlaveLoadBalanceStrategy masterSlaveLoadBalanceStrategy;

    public MasterSlaveDataSource(String name, String masterDataSourceName, DataSource masterDataSource, Map<String, DataSource> slaveDataSources, MasterSlaveLoadBalanceStrategyType strategyType) throws SQLException {
        this(name, masterDataSourceName, masterDataSource, slaveDataSources, strategyType.getStrategy());
    }

    public MasterSlaveDataSource(String name, String masterDataSourceName, DataSource masterDataSource, Map<String, DataSource> slaveDataSources, MasterSlaveLoadBalanceStrategy masterSlaveLoadBalanceStrategy) throws SQLException {
        super(MasterSlaveDataSource.getAllDataSources(masterDataSource, slaveDataSources.values()));
        this.name = name;
        this.masterDataSourceName = masterDataSourceName;
        this.masterDataSource = masterDataSource;
        this.slaveDataSources = slaveDataSources;
        this.masterSlaveLoadBalanceStrategy = masterSlaveLoadBalanceStrategy;
    }

    private static Collection<DataSource> getAllDataSources(DataSource masterDataSource, Collection<DataSource> slaveDataSources) {
        LinkedList<DataSource> result = new LinkedList<DataSource>(slaveDataSources);
        result.add(masterDataSource);
        return result;
    }

    public Map<String, DataSource> getAllDataSources() {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(this.slaveDataSources.size() + 1, 1.0f);
        result.put(this.masterDataSourceName, this.masterDataSource);
        result.putAll(this.slaveDataSources);
        return result;
    }

    public static void resetDMLFlag() {
        DML_FLAG.remove();
    }

    public NamedDataSource getDataSource(SQLType sqlType) {
        if (this.isMasterRoute(sqlType)) {
            DML_FLAG.set(true);
            return new NamedDataSource(this.masterDataSourceName, this.masterDataSource);
        }
        String selectedSourceName = this.masterSlaveLoadBalanceStrategy.getDataSource(this.name, this.masterDataSourceName, new ArrayList<String>(this.slaveDataSources.keySet()));
        DataSource selectedSource = selectedSourceName.equals(this.masterDataSourceName) ? this.masterDataSource : this.slaveDataSources.get(selectedSourceName);
        Preconditions.checkNotNull((Object)selectedSource, (Object)"");
        return new NamedDataSource(selectedSourceName, selectedSource);
    }

    private boolean isMasterRoute(SQLType sqlType) {
        return SQLType.DQL != sqlType || DML_FLAG.get() != false || HintManagerHolder.isMasterRouteOnly();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new MasterSlaveConnection(this);
    }

    public DataSource getMasterDataSource() {
        return this.masterDataSource;
    }

    public Map<String, DataSource> getSlaveDataSources() {
        return this.slaveDataSources;
    }
}

