/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.statement;

import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.executor.type.batch.BatchPreparedStatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.type.batch.BatchPreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.executor.type.prepared.PreparedStatementExecutor;
import com.dangdang.ddframe.rdb.sharding.executor.type.prepared.PreparedStatementUnit;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractShardingPreparedStatementAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.connection.ShardingConnection;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset.GeneratedKeysResultSet;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.resultset.ShardingResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.MergeEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GeneratedKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.routing.PreparedStatementRoutingEngine;
import com.dangdang.ddframe.rdb.sharding.routing.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.routing.SQLRouteResult;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class ShardingPreparedStatement
extends AbstractShardingPreparedStatementAdapter {
    private final ShardingConnection connection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final PreparedStatementRoutingEngine routingEngine;
    private final List<BatchPreparedStatementUnit> batchStatementUnits = new LinkedList<BatchPreparedStatementUnit>();
    private final List<List<Object>> parameterSets = new LinkedList<List<Object>>();
    private final Collection<PreparedStatement> routedStatements = new LinkedList<PreparedStatement>();
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingPreparedStatement(ShardingConnection connection, String sql) {
        this(connection, sql, 1003, 1007, 1);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency) {
        this(connection, sql, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int autoGeneratedKeys) {
        this(connection, sql);
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.routingEngine = new PreparedStatementRoutingEngine(sql, connection.getShardingContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingResultSet result;
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            List<ResultSet> resultSets = new PreparedStatementExecutor(this.getConnection().getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), preparedStatementUnits, this.getParameters()).executeQuery();
            result = new ShardingResultSet(resultSets, new MergeEngine(resultSets, (SelectStatement)this.routeResult.getSqlStatement()).merge());
        }
        finally {
            this.clearBatch();
        }
        this.currentResultSet = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            int n = new PreparedStatementExecutor(this.getConnection().getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), preparedStatementUnits, this.getParameters()).executeUpdate();
            return n;
        }
        finally {
            this.clearBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            boolean bl = new PreparedStatementExecutor(this.getConnection().getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), preparedStatementUnits, this.getParameters()).execute();
            return bl;
        }
        finally {
            this.clearBatch();
        }
    }

    private Collection<PreparedStatementUnit> route() throws SQLException {
        LinkedList<PreparedStatementUnit> result = new LinkedList<PreparedStatementUnit>();
        this.routeResult = this.routingEngine.route(this.getParameters());
        for (SQLExecutionUnit each : this.routeResult.getExecutionUnits()) {
            SQLType sqlType = this.routeResult.getSqlStatement().getType();
            Collection<PreparedStatement> preparedStatements = SQLType.DDL == sqlType ? this.generatePreparedStatementForDDL(each) : Collections.singletonList(this.generatePreparedStatement(each));
            this.routedStatements.addAll(preparedStatements);
            for (PreparedStatement preparedStatement : preparedStatements) {
                this.replaySetParameter(preparedStatement);
                result.add(new PreparedStatementUnit(each, preparedStatement));
            }
        }
        return result;
    }

    private Collection<PreparedStatement> generatePreparedStatementForDDL(SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        LinkedList<PreparedStatement> result = new LinkedList<PreparedStatement>();
        Collection<Connection> connections = this.getConnection().getAllConnections(sqlExecutionUnit.getDataSource());
        for (Connection each : connections) {
            result.add(each.prepareStatement(sqlExecutionUnit.getSql(), this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability));
        }
        return result;
    }

    private PreparedStatement generatePreparedStatement(SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        Connection connection = this.getConnection().getConnection(sqlExecutionUnit.getDataSource(), this.routeResult.getSqlStatement().getType());
        return this.returnGeneratedKeys ? connection.prepareStatement(sqlExecutionUnit.getSql(), 1) : connection.prepareStatement(sqlExecutionUnit.getSql(), this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.currentResultSet = null;
        this.clearParameters();
        this.batchStatementUnits.clear();
        this.parameterSets.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            for (BatchPreparedStatementUnit each : this.routeBatch()) {
                each.getStatement().addBatch();
                each.mapAddBatchCount(this.parameterSets.size());
            }
            this.parameterSets.add(this.getParameters());
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    private List<BatchPreparedStatementUnit> routeBatch() throws SQLException {
        ArrayList<BatchPreparedStatementUnit> result = new ArrayList<BatchPreparedStatementUnit>();
        this.routeResult = this.routingEngine.route(this.getParameters());
        for (SQLExecutionUnit each : this.routeResult.getExecutionUnits()) {
            BatchPreparedStatementUnit batchStatementUnit = this.getPreparedBatchStatement(each);
            this.replaySetParameter(batchStatementUnit.getStatement());
            result.add(batchStatementUnit);
        }
        return result;
    }

    private BatchPreparedStatementUnit getPreparedBatchStatement(final SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        Optional preparedBatchStatement = Iterators.tryFind(this.batchStatementUnits.iterator(), (Predicate)new Predicate<BatchPreparedStatementUnit>(){

            public boolean apply(BatchPreparedStatementUnit input) {
                return Objects.equals(input.getSqlExecutionUnit(), sqlExecutionUnit);
            }
        });
        if (preparedBatchStatement.isPresent()) {
            return (BatchPreparedStatementUnit)preparedBatchStatement.get();
        }
        BatchPreparedStatementUnit result = new BatchPreparedStatementUnit(sqlExecutionUnit, this.generatePreparedStatement(sqlExecutionUnit));
        this.batchStatementUnits.add(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = new BatchPreparedStatementExecutor(this.getConnection().getShardingContext().getExecutorEngine(), this.getConnection().getShardingContext().getDatabaseType(), this.routeResult.getSqlStatement().getType(), this.batchStatementUnits, this.parameterSets).executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn(), this);
        }
        if (1 == this.routedStatements.size()) {
            return this.routedStatements.iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)((InsertStatement)this.routeResult.getSqlStatement()).getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.routedStatements.size()) {
            this.currentResultSet = this.routedStatements.iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.routedStatements.size());
        for (PreparedStatement each : this.routedStatements) {
            resultSets.add(each.getResultSet());
        }
        this.currentResultSet = new ShardingResultSet(resultSets, new MergeEngine(resultSets, (SelectStatement)this.routeResult.getSqlStatement()).merge());
        return this.currentResultSet;
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public PreparedStatementRoutingEngine getRoutingEngine() {
        return this.routingEngine;
    }

    public List<BatchPreparedStatementUnit> getBatchStatementUnits() {
        return this.batchStatementUnits;
    }

    public List<List<Object>> getParameterSets() {
        return this.parameterSets;
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.routedStatements;
    }
}

