/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.common;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MemoryResultSetRow {
    private final Object[] data;

    public MemoryResultSetRow(ResultSet resultSet) throws SQLException {
        this.data = this.load(resultSet);
    }

    private Object[] load(ResultSet resultSet) throws SQLException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        Object[] result = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            result[i] = resultSet.getObject(i + 1);
        }
        return result;
    }

    public Object getCell(int columnIndex) {
        Preconditions.checkArgument((columnIndex > 0 && columnIndex < this.data.length + 1 ? 1 : 0) != 0);
        return this.data[columnIndex - 1];
    }

    public void setCell(int columnIndex, Object value) {
        Preconditions.checkArgument((columnIndex > 0 && columnIndex < this.data.length + 1 ? 1 : 0) != 0);
        this.data[columnIndex - 1] = value;
    }
}

