/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.clause;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.ExpressionClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.GeneratedKey;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Condition;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Conditions;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.MultipleInsertValuesToken;
import java.util.Arrays;
import java.util.LinkedList;

public class InsertValuesClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final ExpressionClauseParser expressionClauseParser;

    public InsertValuesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement) {
        LinkedList<Keyword> valueKeywords = new LinkedList<Keyword>();
        valueKeywords.add(DefaultKeyword.VALUES);
        valueKeywords.addAll(Arrays.asList(this.getSynonymousKeywordsForValues()));
        if (this.lexerEngine.skipIfEqual(valueKeywords.toArray(new Keyword[valueKeywords.size()]))) {
            insertStatement.setAfterValuesPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
            this.parseValues(insertStatement);
            if (this.lexerEngine.equalAny(Symbol.COMMA)) {
                this.parseMultipleValues(insertStatement);
            }
        }
    }

    protected Keyword[] getSynonymousKeywordsForValues() {
        return new Keyword[0];
    }

    private void parseValues(InsertStatement insertStatement) {
        this.lexerEngine.accept(Symbol.LEFT_PAREN);
        LinkedList<SQLExpression> sqlExpressions = new LinkedList<SQLExpression>();
        do {
            sqlExpressions.add(this.expressionClauseParser.parse(insertStatement));
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        insertStatement.setValuesListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
        int count = 0;
        for (Column each : insertStatement.getColumns()) {
            SQLExpression sqlExpression = (SQLExpression)sqlExpressions.get(count);
            insertStatement.getConditions().add(new Condition(each, sqlExpression), this.shardingRule);
            if (insertStatement.getGenerateKeyColumnIndex() == count) {
                insertStatement.setGeneratedKey(this.createGeneratedKey(each, sqlExpression));
            }
            ++count;
        }
        this.lexerEngine.accept(Symbol.RIGHT_PAREN);
    }

    private GeneratedKey createGeneratedKey(Column column, SQLExpression sqlExpression) {
        GeneratedKey result;
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            result = new GeneratedKey(column.getName(), ((SQLPlaceholderExpression)sqlExpression).getIndex(), null);
        } else if (sqlExpression instanceof SQLNumberExpression) {
            result = new GeneratedKey(column.getName(), -1, ((SQLNumberExpression)sqlExpression).getNumber());
        } else {
            throw new ShardingJdbcException("Generated key only support number.", new Object[0]);
        }
        return result;
    }

    private void parseMultipleValues(InsertStatement insertStatement) {
        insertStatement.getMultipleConditions().add(new Conditions(insertStatement.getConditions()));
        MultipleInsertValuesToken valuesToken = new MultipleInsertValuesToken(insertStatement.getAfterValuesPosition());
        valuesToken.getValues().add(this.lexerEngine.getInput().substring(insertStatement.getAfterValuesPosition(), this.lexerEngine.getCurrentToken().getEndPosition() - Symbol.COMMA.getLiterals().length()));
        while (this.lexerEngine.skipIfEqual(Symbol.COMMA)) {
            int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            this.parseValues(insertStatement);
            insertStatement.getMultipleConditions().add(new Conditions(insertStatement.getConditions()));
            int endPosition = this.lexerEngine.equalAny(Symbol.COMMA) ? this.lexerEngine.getCurrentToken().getEndPosition() - Symbol.COMMA.getLiterals().length() : this.lexerEngine.getCurrentToken().getEndPosition();
            valuesToken.getValues().add(this.lexerEngine.getInput().substring(beginPosition, endPosition));
        }
        insertStatement.getSqlTokens().add(valuesToken);
    }
}

