/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.api.rule;

import com.dangdang.ddframe.rdb.sharding.api.rule.BindingTableRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataSourceRule;
import com.dangdang.ddframe.rdb.sharding.api.rule.TableRule;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.NoneDatabaseShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.NoneTableShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.api.strategy.table.TableShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.keygen.DefaultKeyGenerator;
import com.dangdang.ddframe.rdb.sharding.keygen.KeyGenerator;
import com.dangdang.ddframe.rdb.sharding.keygen.KeyGeneratorFactory;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.sql.DataSource;

public final class ShardingRule {
    private final DataSourceRule dataSourceRule;
    private final Collection<TableRule> tableRules;
    private final Collection<BindingTableRule> bindingTableRules;
    private final DatabaseShardingStrategy databaseShardingStrategy;
    private final TableShardingStrategy tableShardingStrategy;
    private final KeyGenerator keyGenerator;
    private final KeyGenerator defaultGenerator;

    @Deprecated
    public ShardingRule(DataSourceRule dataSourceRule, Collection<TableRule> tableRules, Collection<BindingTableRule> bindingTableRules, DatabaseShardingStrategy databaseShardingStrategy, TableShardingStrategy tableShardingStrategy, KeyGenerator keyGenerator) {
        Preconditions.checkNotNull((Object)dataSourceRule);
        this.dataSourceRule = dataSourceRule;
        this.tableRules = null == tableRules ? Collections.emptyList() : tableRules;
        this.bindingTableRules = null == bindingTableRules ? Collections.emptyList() : bindingTableRules;
        this.databaseShardingStrategy = null == databaseShardingStrategy ? new DatabaseShardingStrategy(Collections.emptyList(), new NoneDatabaseShardingAlgorithm()) : databaseShardingStrategy;
        this.tableShardingStrategy = null == tableShardingStrategy ? new TableShardingStrategy(Collections.emptyList(), new NoneTableShardingAlgorithm()) : tableShardingStrategy;
        this.keyGenerator = keyGenerator;
        this.defaultGenerator = KeyGeneratorFactory.createKeyGenerator(DefaultKeyGenerator.class);
    }

    public static ShardingRuleBuilder builder() {
        return new ShardingRuleBuilder();
    }

    public Optional<TableRule> tryFindTableRule(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(logicTableName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.tryFindTableRule(logicTableName);
        if (tableRule.isPresent()) {
            return (TableRule)tableRule.get();
        }
        if (this.dataSourceRule.getDefaultDataSource().isPresent()) {
            return this.createTableRuleWithDefaultDataSource(logicTableName, this.dataSourceRule);
        }
        throw new ShardingJdbcException("Cannot find table rule and default data source with logic table: '%s'", logicTableName);
    }

    private TableRule createTableRuleWithDefaultDataSource(String logicTableName, DataSourceRule defaultDataSourceRule) {
        HashMap<String, DataSource> defaultDataSourceMap = new HashMap<String, DataSource>(1);
        defaultDataSourceMap.put(defaultDataSourceRule.getDefaultDataSourceName(), (DataSource)defaultDataSourceRule.getDefaultDataSource().get());
        return TableRule.builder(logicTableName).dataSourceRule(new DataSourceRule(defaultDataSourceMap)).databaseShardingStrategy(new DatabaseShardingStrategy("", new NoneDatabaseShardingAlgorithm())).tableShardingStrategy(new TableShardingStrategy("", new NoneTableShardingAlgorithm())).build();
    }

    public DatabaseShardingStrategy getDatabaseShardingStrategy(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategy() ? this.databaseShardingStrategy : tableRule.getDatabaseShardingStrategy();
    }

    public TableShardingStrategy getTableShardingStrategy(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategy() ? this.tableShardingStrategy : tableRule.getTableShardingStrategy();
    }

    public boolean isAllBindingTables(Collection<String> logicTables) {
        Collection<String> bindingTables = this.filterAllBindingTables(logicTables);
        return !bindingTables.isEmpty() && bindingTables.containsAll(logicTables);
    }

    public Collection<String> filterAllBindingTables(Collection<String> logicTables) {
        if (logicTables.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTables);
        if (!bindingTableRule.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(((BindingTableRule)bindingTableRule.get()).getAllLogicTables());
        result.retainAll(logicTables);
        return result;
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTables) {
        for (String each : logicTables) {
            Optional<BindingTableRule> result = this.findBindingTableRule(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTable) {
        for (BindingTableRule each : this.bindingTableRules) {
            if (!each.hasLogicTable(logicTable)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public boolean isShardingColumn(Column column) {
        if (this.databaseShardingStrategy.getShardingColumns().contains(column.getName()) || this.tableShardingStrategy.getShardingColumns().contains(column.getName())) {
            return true;
        }
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(column.getTableName())) continue;
            if (null != each.getDatabaseShardingStrategy() && each.getDatabaseShardingStrategy().getShardingColumns().contains(column.getName())) {
                return true;
            }
            if (null == each.getTableShardingStrategy() || !each.getTableShardingStrategy().getShardingColumns().contains(column.getName())) continue;
            return true;
        }
        return false;
    }

    public Optional<String> getGenerateKeyColumn(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(logicTableName)) continue;
            return Optional.fromNullable((Object)each.getGenerateKeyColumn());
        }
        return Optional.absent();
    }

    public Number generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.tryFindTableRule(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingJdbcException("Cannot find strategy for generate keys.", new Object[0]);
        }
        if (null != ((TableRule)tableRule.get()).getKeyGenerator()) {
            return ((TableRule)tableRule.get()).getKeyGenerator().generateKey();
        }
        if (null != this.keyGenerator) {
            return this.keyGenerator.generateKey();
        }
        return this.defaultGenerator.generateKey();
    }

    public DataSourceRule getDataSourceRule() {
        return this.dataSourceRule;
    }

    public Collection<TableRule> getTableRules() {
        return this.tableRules;
    }

    public Collection<BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    public DatabaseShardingStrategy getDatabaseShardingStrategy() {
        return this.databaseShardingStrategy;
    }

    public TableShardingStrategy getTableShardingStrategy() {
        return this.tableShardingStrategy;
    }

    public static class ShardingRuleBuilder {
        private DataSourceRule dataSourceRule;
        private Collection<TableRule> tableRules;
        private Collection<BindingTableRule> bindingTableRules;
        private DatabaseShardingStrategy databaseShardingStrategy;
        private TableShardingStrategy tableShardingStrategy;
        private Class<? extends KeyGenerator> keyGeneratorClass;

        public ShardingRuleBuilder dataSourceRule(DataSourceRule dataSourceRule) {
            this.dataSourceRule = dataSourceRule;
            return this;
        }

        public ShardingRuleBuilder tableRules(Collection<TableRule> tableRules) {
            this.tableRules = tableRules;
            return this;
        }

        public ShardingRuleBuilder bindingTableRules(Collection<BindingTableRule> bindingTableRules) {
            this.bindingTableRules = bindingTableRules;
            return this;
        }

        public ShardingRuleBuilder databaseShardingStrategy(DatabaseShardingStrategy databaseShardingStrategy) {
            this.databaseShardingStrategy = databaseShardingStrategy;
            return this;
        }

        public ShardingRuleBuilder tableShardingStrategy(TableShardingStrategy tableShardingStrategy) {
            this.tableShardingStrategy = tableShardingStrategy;
            return this;
        }

        public ShardingRuleBuilder keyGenerator(Class<? extends KeyGenerator> keyGeneratorClass) {
            this.keyGeneratorClass = keyGeneratorClass;
            return this;
        }

        public ShardingRule build() {
            KeyGenerator keyGenerator = null;
            if (null != this.keyGeneratorClass) {
                keyGenerator = KeyGeneratorFactory.createKeyGenerator(this.keyGeneratorClass);
            }
            return new ShardingRule(this.dataSourceRule, this.tableRules, this.bindingTableRules, this.databaseShardingStrategy, this.tableShardingStrategy, keyGenerator);
        }
    }
}

