/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.adapter;

import com.dangdang.ddframe.rdb.sharding.jdbc.unsupported.AbstractUnsupportedOperationResultSet;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultSetAdapter
extends AbstractUnsupportedOperationResultSet {
    private static final Logger log = LoggerFactory.getLogger(AbstractResultSetAdapter.class);
    private final List<ResultSet> resultSets;
    private boolean closed;

    public AbstractResultSetAdapter(List<ResultSet> resultSets) {
        Preconditions.checkArgument((!resultSets.isEmpty() ? 1 : 0) != 0);
        this.resultSets = resultSets;
    }

    @Override
    public final Statement getStatement() throws SQLException {
        return this.getResultSets().get(0).getStatement();
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSets().get(0).getMetaData();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getResultSets().get(0).findColumn(columnLabel);
    }

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (ResultSet each : this.resultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (ResultSet each : this.resultSets) {
            try {
                each.setFetchDirection(direction);
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.getResultSets().get(0).getFetchDirection();
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (ResultSet each : this.resultSets) {
            try {
                each.setFetchSize(rows);
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.getResultSets().get(0).getFetchSize();
    }

    @Override
    public final int getType() throws SQLException {
        return this.getResultSets().get(0).getType();
    }

    @Override
    public final int getConcurrency() throws SQLException {
        return this.getResultSets().get(0).getConcurrency();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.getResultSets().get(0).getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (ResultSet each : this.getResultSets()) {
            try {
                each.clearWarnings();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    public List<ResultSet> getResultSets() {
        return this.resultSets;
    }
}

