/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc.core.connection;

import com.dangdang.ddframe.rdb.sharding.constant.SQLType;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractConnectionAdapter;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.datasource.MasterSlaveDataSource;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.statement.MasterSlavePreparedStatement;
import com.dangdang.ddframe.rdb.sharding.jdbc.core.statement.MasterSlaveStatement;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;

public final class MasterSlaveConnection
extends AbstractConnectionAdapter {
    private final MasterSlaveDataSource masterSlaveDataSource;
    private SQLType cachedSQLType;

    public Collection<Connection> getConnections(SQLType sqlType) throws SQLException {
        this.cachedSQLType = sqlType;
        Map<String, DataSource> dataSources = SQLType.DDL == sqlType ? this.masterSlaveDataSource.getAllDataSources() : this.masterSlaveDataSource.getDataSource(sqlType).toMap();
        LinkedList<Connection> result = new LinkedList<Connection>();
        for (Map.Entry<String, DataSource> each : dataSources.entrySet()) {
            String dataSourceName = each.getKey();
            if (this.getCachedConnections().containsKey(dataSourceName)) {
                result.add(this.getCachedConnections().get(dataSourceName));
                continue;
            }
            Connection connection = each.getValue().getConnection();
            this.getCachedConnections().put(dataSourceName, connection);
            result.add(connection);
            this.replayMethodsInvocation(connection);
        }
        return result;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnections(null == this.cachedSQLType ? SQLType.DML : this.cachedSQLType).iterator().next().getMetaData();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new MasterSlaveStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new MasterSlaveStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new MasterSlaveStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new MasterSlavePreparedStatement(this, sql, columnNames);
    }

    @Override
    public void close() throws SQLException {
        HintManagerHolder.clear();
        MasterSlaveDataSource.resetDMLFlag();
        super.close();
    }

    @ConstructorProperties(value={"masterSlaveDataSource"})
    public MasterSlaveConnection(MasterSlaveDataSource masterSlaveDataSource) {
        this.masterSlaveDataSource = masterSlaveDataSource;
    }
}

