/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql.clause;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.postgresql.PostgreSQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Literals;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.Limit;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.limit.LimitValue;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.exception.SQLParsingException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.OffsetToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.RowCountToken;
import com.dangdang.ddframe.rdb.sharding.util.NumberUtil;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;

public final class PostgreSQLLimitClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;

    public void parse(SelectStatement selectStatement) {
        Optional<LimitValue> offset = Optional.absent();
        Optional<LimitValue> rowCount = Optional.absent();
        while (true) {
            if (this.lexerEngine.skipIfEqual(PostgreSQLKeyword.LIMIT)) {
                rowCount = this.buildRowCount(selectStatement);
                continue;
            }
            if (!this.lexerEngine.skipIfEqual(PostgreSQLKeyword.OFFSET)) break;
            offset = this.buildOffset(selectStatement);
        }
        if (offset.isPresent() || rowCount.isPresent()) {
            this.setLimit(offset, rowCount, selectStatement);
        }
    }

    private Optional<LimitValue> buildRowCount(SelectStatement selectStatement) {
        int parameterIndex = selectStatement.getParametersIndex();
        int rowCountValue = -1;
        int rowCountIndex = -1;
        int valueBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        if (this.lexerEngine.equalAny(DefaultKeyword.ALL)) {
            this.lexerEngine.nextToken();
        } else {
            if (this.lexerEngine.equalAny(Literals.INT, Literals.FLOAT)) {
                rowCountValue = NumberUtil.roundHalfUp(this.lexerEngine.getCurrentToken().getLiterals());
                selectStatement.getSqlTokens().add(new RowCountToken(valueBeginPosition -= (rowCountValue + "").length(), rowCountValue));
            } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
                rowCountIndex = parameterIndex++;
                selectStatement.setParametersIndex(parameterIndex);
                rowCountValue = -1;
            } else {
                throw new SQLParsingException(this.lexerEngine);
            }
            this.lexerEngine.nextToken();
        }
        return Optional.of((Object)new LimitValue(rowCountValue, rowCountIndex));
    }

    private Optional<LimitValue> buildOffset(SelectStatement selectStatement) {
        int parameterIndex = selectStatement.getParametersIndex();
        int offsetValue = -1;
        int offsetIndex = -1;
        int offsetBeginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        if (this.lexerEngine.equalAny(Literals.INT, Literals.FLOAT)) {
            offsetValue = NumberUtil.roundHalfUp(this.lexerEngine.getCurrentToken().getLiterals());
            selectStatement.getSqlTokens().add(new OffsetToken(offsetBeginPosition -= (offsetValue + "").length(), offsetValue));
        } else if (this.lexerEngine.equalAny(Symbol.QUESTION)) {
            offsetIndex = parameterIndex++;
            selectStatement.setParametersIndex(parameterIndex);
        } else {
            throw new SQLParsingException(this.lexerEngine);
        }
        this.lexerEngine.nextToken();
        this.lexerEngine.skipIfEqual(DefaultKeyword.ROW, PostgreSQLKeyword.ROWS);
        return Optional.of((Object)new LimitValue(offsetValue, offsetIndex));
    }

    private void setLimit(Optional<LimitValue> offset, Optional<LimitValue> rowCount, SelectStatement selectStatement) {
        Limit limit = new Limit(true);
        if (offset.isPresent()) {
            limit.setOffset((LimitValue)offset.get());
        }
        if (rowCount.isPresent()) {
            limit.setRowCount((LimitValue)rowCount.get());
        }
        selectStatement.setLimit(limit);
    }

    @ConstructorProperties(value={"lexerEngine"})
    public PostgreSQLLimitClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

