/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.alter;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.sql.MySQLAlterParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.sql.OracleAlterParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql.sql.PostgreSQLAlterParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver.sql.SQLServerAlterParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.ddl.alter.AbstractAlterParser;

public final class AlterParserFactory {
    public static AbstractAlterParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLAlterParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleAlterParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerAlterParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLAlterParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private AlterParserFactory() {
    }
}

