/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.provisioning.CreateWorkspaceRequest;
import com.databricks.sdk.service.provisioning.DeleteWorkspaceRequest;
import com.databricks.sdk.service.provisioning.GetWorkspaceRequest;
import com.databricks.sdk.service.provisioning.UpdateWorkspaceRequest;
import com.databricks.sdk.service.provisioning.Workspace;
import com.databricks.sdk.service.provisioning.WorkspacesService;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import java.util.HashMap;

@Generated
class WorkspacesImpl
implements WorkspacesService {
    private final ApiClient apiClient;

    public WorkspacesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Workspace create(CreateWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Workspace.class, headers);
    }

    @Override
    public void delete(DeleteWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public Workspace get(GetWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Workspace.class, headers);
    }

    @Override
    public Collection<Workspace> list() {
        String path = String.format("/api/2.0/accounts/%s/workspaces", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.getCollection(path, null, Workspace.class, headers);
    }

    @Override
    public void update(UpdateWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, Void.class, headers);
    }
}

