/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CancelRefreshRequest;
import com.databricks.sdk.service.catalog.CreateMonitor;
import com.databricks.sdk.service.catalog.DeleteLakehouseMonitorRequest;
import com.databricks.sdk.service.catalog.GetLakehouseMonitorRequest;
import com.databricks.sdk.service.catalog.GetRefreshRequest;
import com.databricks.sdk.service.catalog.LakehouseMonitorsImpl;
import com.databricks.sdk.service.catalog.LakehouseMonitorsService;
import com.databricks.sdk.service.catalog.ListRefreshesRequest;
import com.databricks.sdk.service.catalog.MonitorInfo;
import com.databricks.sdk.service.catalog.MonitorRefreshInfo;
import com.databricks.sdk.service.catalog.RunRefreshRequest;
import com.databricks.sdk.service.catalog.UpdateMonitor;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class LakehouseMonitorsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LakehouseMonitorsAPI.class);
    private final LakehouseMonitorsService impl;

    public LakehouseMonitorsAPI(ApiClient apiClient) {
        this.impl = new LakehouseMonitorsImpl(apiClient);
    }

    public LakehouseMonitorsAPI(LakehouseMonitorsService mock) {
        this.impl = mock;
    }

    public void cancelRefresh(String fullName, String refreshId) {
        this.cancelRefresh(new CancelRefreshRequest().setFullName(fullName).setRefreshId(refreshId));
    }

    public void cancelRefresh(CancelRefreshRequest request) {
        this.impl.cancelRefresh(request);
    }

    public MonitorInfo create(String fullName, String assetsDir, String outputSchemaName) {
        return this.create(new CreateMonitor().setFullName(fullName).setAssetsDir(assetsDir).setOutputSchemaName(outputSchemaName));
    }

    public MonitorInfo create(CreateMonitor request) {
        return this.impl.create(request);
    }

    public void delete(String fullName) {
        this.delete(new DeleteLakehouseMonitorRequest().setFullName(fullName));
    }

    public void delete(DeleteLakehouseMonitorRequest request) {
        this.impl.delete(request);
    }

    public MonitorInfo get(String fullName) {
        return this.get(new GetLakehouseMonitorRequest().setFullName(fullName));
    }

    public MonitorInfo get(GetLakehouseMonitorRequest request) {
        return this.impl.get(request);
    }

    public MonitorRefreshInfo getRefresh(String fullName, String refreshId) {
        return this.getRefresh(new GetRefreshRequest().setFullName(fullName).setRefreshId(refreshId));
    }

    public MonitorRefreshInfo getRefresh(GetRefreshRequest request) {
        return this.impl.getRefresh(request);
    }

    public Iterable<MonitorRefreshInfo> listRefreshes(String fullName) {
        return this.listRefreshes(new ListRefreshesRequest().setFullName(fullName));
    }

    public Iterable<MonitorRefreshInfo> listRefreshes(ListRefreshesRequest request) {
        return this.impl.listRefreshes(request);
    }

    public MonitorRefreshInfo runRefresh(String fullName) {
        return this.runRefresh(new RunRefreshRequest().setFullName(fullName));
    }

    public MonitorRefreshInfo runRefresh(RunRefreshRequest request) {
        return this.impl.runRefresh(request);
    }

    public MonitorInfo update(String fullName, String assetsDir, String outputSchemaName) {
        return this.update(new UpdateMonitor().setFullName(fullName).setAssetsDir(assetsDir).setOutputSchemaName(outputSchemaName));
    }

    public MonitorInfo update(UpdateMonitor request) {
        return this.impl.update(request);
    }

    public LakehouseMonitorsService impl() {
        return this.impl;
    }
}

