/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.AccountIpAccessListsService;
import com.databricks.sdk.service.settings.CreateIpAccessList;
import com.databricks.sdk.service.settings.CreateIpAccessListResponse;
import com.databricks.sdk.service.settings.DeleteAccountIpAccessListRequest;
import com.databricks.sdk.service.settings.GetAccountIpAccessListRequest;
import com.databricks.sdk.service.settings.GetIpAccessListResponse;
import com.databricks.sdk.service.settings.GetIpAccessListsResponse;
import com.databricks.sdk.service.settings.ReplaceIpAccessList;
import com.databricks.sdk.service.settings.UpdateIpAccessList;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class AccountIpAccessListsImpl
implements AccountIpAccessListsService {
    private final ApiClient apiClient;

    public AccountIpAccessListsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateIpAccessListResponse create(CreateIpAccessList request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CreateIpAccessListResponse.class, headers);
    }

    @Override
    public void delete(DeleteAccountIpAccessListRequest request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public GetIpAccessListResponse get(GetAccountIpAccessListRequest request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetIpAccessListResponse.class, headers);
    }

    @Override
    public GetIpAccessListsResponse list() {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, GetIpAccessListsResponse.class, headers);
    }

    @Override
    public void replace(ReplaceIpAccessList request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PUT(path, request, Void.class, headers);
    }

    @Override
    public void update(UpdateIpAccessList request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, Void.class, headers);
    }
}

